// JavaScript Document
(function($) {
    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays relevant information about the Wide Area Network (Internet) connection."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "The unique physical address assigned to the Internet (WAN) port of the router."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "The IP address assigned to the Internet (WAN) port of the router. If the IP address is shown as 0.0.0.0, this indicates no Internet access."
                }, {
                    type: "name",
                    title: "Subnet Mask",
                    content: "This parameter determines the network portion and the host portion of an IP address."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "The IP address used to connect the router to the network."
                }, {
                    type: "name",
                    title: "Primary DNS/Secondary DNS",
                    content: "The Domain Name System (DNS) translates host names and internet domains to IP addresses. The information of these DNS servers is assigned by the Internet Service Provider (ISP)."
                }, {
                    type: "name",
                    title: "Connection Type",
                    content: "The current connection type of the Internet (WAN) port."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "The unique physical address assigned to the Internet (WAN) port of the router."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "The IP address assigned to the Internet (WAN) port of the router."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "The IP address used to connect the router to the network."
                }, {
                    type: "name",
                    title: "Primary DNS/Secondary DNS",
                    content: "The Domain Name System (DNS) translates host names and internet domains to IP addresses. The information of these DNS servers is assigned by the Internet Service Provider (ISP)."
                }, {
                    type: "name",
                    title: "Connection Type",
                    content: "The current connection type of the Internet (WAN) port."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Powerline Network",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Click the Powerline Network icon to display the list of all powerline devices in the current powerline network."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Click the Powerline icon to display the detailed information of the local powerline extender."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "The unique identifier that is assigned to the powerline extender."
                }, {
                    type: "name",
                    title: "Powerline Key",
                    content: "The unique key of this powerline device that is used when being added to a powerline network. The key is also printed on the product label."
                }, {
                    type: "name",
                    title: "Network Name",
                    content: "The network name that the powerline extender is in. The default is HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> Wireless Network",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays the status and basic information of the Wireless Network."
                }, {
                    type: "name",
                    title: "Status",
                    content: "The current status (On or Off) of your Wireless Network."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Service Set Identifier, also known as wireless network name."
                }, {
                    type: "name",
                    title: "Channel",
                    content: "The current wireless channel."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "The MAC address of the powerline extender's wireless radio."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays information about the Ethernet (LAN) ports."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "The unique physical address assigned to the Ethernet (LAN) port of the router."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "The IPv4 address assigned to the Ethernet (LAN) port of the router."
                }, {
                    type: "name",
                    title: "Subnet Mask",
                    content: "This parameter determines the network portion and the host portion of an IP address."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Displays whether the router’s built-in DHCP server is active for devices on the LAN ports or not."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "The unique physical address assigned to the Ethernet (LAN) port of the router."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "The IPv6 address assigned to the Internet (LAN) port of the router."
                }, {
                    type: "name",
                    title: "Link-local Address",
                    content: "The IPv6 link address for the LAN interface."
                }, {
                    type: "name",
                    title: "Assigned Type",
                    content: "The type of IPv6 address for the LAN interface."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> Guest Network",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays information about the wireless network for guests."
                }, {
                    type: "name",
                    title: "Status",
                    content: "The current status (On or Off) of your Guest Network."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "The wireless network name of your Guest Network."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "USB Devices",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays information of the current USB storage devices and/or printers connected to the router via the USB ports."
                }, {
                    type: "name",
                    title: "Printer",
                    content: "The name of the connected printer."
                }, {
                    type: "name",
                    title: "Total",
                    content: "The total storage capacity of the connected USB storage device."
                }, {
                    type: "name",
                    title: "Available",
                    content: "The available storage capacity of the connected USB storage device."
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Performance",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays the current router performance."
                }, {
                    type: "name",
                    title: "CPU Load",
                    content: "The current CPU usage."
                }, {
                    type: "name",
                    title: "Memory Usage",
                    content: "The current memory usage."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Wired Clients",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays information of all the wired devices that are currently connected to the network."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Wireless Clients",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Click the Wireless Clients icon to display information of all wireless devices that are currently connected to the wireless network built by the powerline extender."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "The MAC address of the wireless client."
                }, {
                    type: "name",
                    title: "Wireless Band",
                    content: "The wireless band <span class=\"anti_5g\">(2.4GHz or 5GHz) </span>that the client is connected to."
                }
            ]
        },

        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indicates whether the Wi-Fi Move function is enabled or not."
                }
            ]
        },

        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Internet Connection Type: Static IP"
                }, {
                    type: "paragraph",
                    content: "Select this type if you are provided with a specific (fixed) IP Address, Subnet Mask, Gateway, and DNS parameters by the ISP."
                }, {
                    type: "name",
                    title: "IP Address/Subnet Mask/Default Gateway/Primary DNS/Secondary DNS",
                    content: "Enter the information provided by your ISP."
                }, {
                    type: "name",
                    title: "MTU Size",
                    content: "The default and typical MTU (Maximum Transmission Unit) size for most Ethernet networks is 1500 Bytes. It is NOT recommended to change the default MTU size unless required by the ISP."
                }, {
                    type: "title",
                    title: "Internet Connection Type: Dynamic IP"
                }, {
                    type: "paragraph",
                    content: "Select this type if you are provided with a DHCP server connection by the ISP (Internet Service Provider)."
                }, {
                    type: "name",
                    title: "IP Address/Subnet Mask/Default Gateway/Primary DNS/Secondary DNS",
                    content: "These parameters are automatically assigned by the DHCP server from your ISP."
                }, {
                    type: "name",
                    title: "Renew",
                    content: "Click this button to get new IP parameters from the DHCP server."
                }, {
                    type: "name",
                    title: "Release",
                    content: "Click this button to release all IP addresses assigned by the DHCP server."
                }, {
                    type: "name",
                    title: "Use the following DNS Addresses",
                    content: "If the ISP provides one or two DNS addresses, select this checkbox and enter the Primary DNS and Secondary DNS addresses into the corresponding input fields; otherwise, the DNS addresses will be assigned dynamically by the ISP."
                }, {
                    type: "name",
                    title: "MTU Size",
                    content: "The default and typical MTU (Maximum Transmission Unit) size for most Ethernet networks is 1500 Bytes. It is NOT recommended to change the default MTU size unless required by the ISP."
                }, {
                    type: "name",
                    title: "Host Name",
                    content: "Enter a value into this field to specify the host name of the router."
                }, {
                    type: "name",
                    title: "Get IP using Unicast DHCP",
                    content: "Select this checkbox if your ISP’s DHCP server does not support broadcast applications and you cannot get the IP address dynamically."
                }, {
                    type: "note",
                    title: "Note",
                    content: "If you encounter “Address not found” errors after entering the DNS addresses, it is likely that your DNS servers are setup incorrectly; contact the ISP for assistance."
                }, {
                    type: "title",
                    title: "Internet Connection Type: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Select this type if you use DSL (Digital Subscriber Line) service and are provided with a username and password by the ISP."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter the username and password provided by your ISP. These fields are case-sensitive."
                }, {
                    type: "name",
                    title: "Internet IP Address/Primary DNS/Secondary DNS",
                    content: "These parameters are automatically assigned by the DHCP server on your ISP."
                }, {
                    type: "name",
                    title: "Secondary Connection (None, Dynamic IP, Static IP)",
                    children: [
                        {
                            type: "name",
                            title: "None",
                            content: "Select if no secondary connection is provided."
                        }, {
                            type: "name",
                            title: "Dynamic IP",
                            content: "Select if the IP address and Subnet Mask are assigned automatically by the ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renew",
                                    content: "Click this button to renew the IP parameters from your ISP."
                                }, {
                                    type: "name",
                                    title: "Release",
                                    content: "Click this button to release the assigned IP parameters."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Static IP",
                            content: "Select if the IP address, Subnet Mask, Gateway, and DNS addresses are provided by the ISP, and enter these information into the corresponding fields."
                        }
                    ]
                }, {
                    type: "name",
                    title: "MTU Size",
                    content: "The typical MTU (Maximum Transmission Unit) size for Ethernet networks is 1480 Bytes.",
                    children: [
                        {
                            type: "note",
                            title: "Note",
                            content: "In a rare case, your ISP may require you to adjust the MTU size for better network performance. You should not change the value unless it is absolutely necessary."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Service Name/Access Concentrator Name",
                    content: "By default, the Service Name and Access Concentrator (AC) Name are left blank. These fields should not be configured unless required by your ISP."
                }, {
                    type: "name",
                    title: "Detect Online Interval",
                    content: "Enter a time interval value between 0 and 120 (in seconds) for which the router detects Access Concentrator online at every interval. The default value is 0, meaning no detection."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "If your ISP provides a specific (fixed) IP address, select Use the following IP Address and enter the IP address in the field; otherwise select Get Dynamically from ISP to obtain a server-assigned IP address automatically."
                }, {
                    type: "name",
                    title: "DNS Address/Primary DNS/Secondary DNS",
                    content: "If your ISP provides the specific (fixed) DNS IP addresses, select Use the following DNS Address and enter the address(es) into the Primary DNS and Secondary DNS fields respectively; otherwise select Get Dynamically from ISP to obtain the server-assigned DNS IP address(es) automatically."
                }, {
                    type: "name",
                    title: "Connection Mode",
                    content: "Select an appropriate connection mode that determines how to connect to the Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "In this mode, the Internet connection reconnects automatically any time it gets disconnected."
                        }, {
                            type: "name",
                            title: "On Demand",
                            content: "In this mode, the Internet connection will be terminated automatically after a specified time of inactivity (Max Idle Time) has elapsed. The connection is re-established when you attempt to access the Internet again."
                        }, {
                            type: "name",
                            title: "Time-Based",
                            content: "In this mode, the Internet connection is only established in a specific timeframe. If this option is selected, enter the start time and end time; both are in HH:MM format."
                        }, {
                            type: "name",
                            title: "Manually",
                            content: "In this mode, the Internet connection is controlled manually by clicking the Connect or Disconnect button. This mode also supports the Max Idle Time function. Enter a maximum time (in minutes) the Internet connection can be inactive before it is terminated into the Max Idle Time field. The default value is 15 minutes. If you want the Internet connection remains active at all time, enter 0 (zero)."
                        }, {
                            type: "note",
                            title: "Note",
                            content: "The Time-Based connection mode will only take effect once the System Time on the Advanced → System Tools → Time Settings page is configured."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Internet Connection Type: BigPond Cable"
                }, {
                    type: "paragraph",
                    content: "Select this type if your ISP provides BigPond Cable connection."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter the username and password provided by your ISP. These fields are case-sensitive."
                }, {
                    type: "name",
                    title: "Auth. Server",
                    content: "Enter the authenticating server’s IP address or hostname."
                }, {
                    type: "name",
                    title: "Auth. Domain",
                    content: "Enter the server's domain name suffix (based on your location). For example, nsw.bigpond.net.au for NSW/ACT, vic.bigpond.net.au for VIC/TAS/WA/SA/NT, or qld.bigpond.net.au for QLD."
                }, {
                    type: "name",
                    title: "MTU Size",
                    content: "The default and typical MTU (Maximum Transmission Unit) size for most Ethernet networks is 1500 Bytes. It is Not recommended to change the default MTU size unless required by the ISP."
                }, {
                    type: "name",
                    title: "Connection Mode",
                    content: "Select an appropriate connection mode that determines how to connect to the Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "In this mode, the Internet connection reconnects automatically any time it gets disconnected."
                        }, {
                            type: "name",
                            title: "On Demand",
                            content: "In this mode, the Internet connection will be terminated automatically after a specified time of inactivity (Max Idle Time) has elapsed. The connection is re-established when you attempt to access the Internet again."
                        }, {
                            type: "name",
                            title: "Manually",
                            content: "In this mode, the Internet connection is controlled manually by clicking the Connect or Disconnect button. This mode also supports the Max Idle Time function. Enter a maximum time (in minutes) the Internet connection can be inactive before it is terminated into the Max Idle Time field. The default value is 15 minutes. If you want the Internet connection remains active at all time, enter 0 (zero)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Internet Connection Type: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Select this type if you connect to an L2TP/PPTP VPN Server and are provided with a username, password, and IP Address/Domain Name of the server by the ISP."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter the username and password provided by your ISP. These fields are case-sensitive."
                }, {
                    type: "name",
                    title: "Internet IP Address/Primary DNS/Secondary DNS",
                    content: "These parameters will be automatically assigned by the DHCP server from your ISP."
                }, {
                    type: "name",
                    title: "Secondary Connection (Dynamic IP or Static IP)",
                    children: [
                        {
                            type: "name",
                            title: "Dynamic IP",
                            content: "Select if the IP address and Subnet Mask are assigned automatically by the ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renew",
                                    content: "Click this button to renew the IP parameters from your ISP."
                                }, {
                                    type: "name",
                                    title: "Release",
                                    content: "Click this button to release the assigned IP parameters."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Static IP",
                            content: "Select if the IP address, Subnet Mask, Gateway, and DNS addresses are provided by the ISP, and enter these information into the corresponding fields."
                        }
                    ]
                }, {
                    type: "name",
                    title: "VPN Server IP/Domain Name",
                    content: "Enter the VPN server’s IP address or domain name provided by your ISP."
                }, {
                    type: "name",
                    title: "MTU Size",
                    content: "The default and typical MTU (Maximum Transmission Unit) size for most Ethernet networks is 1460 Bytes. It is NOT recommended to change the default MTU size unless required by the ISP."
                }, {
                    type: "name",
                    title: "Connection Mode",
                    content: "Select an appropriate connection mode that determines how to connect to the Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "In this mode, the Internet connection reconnects automatically any time it gets disconnected."
                        }, {
                            type: "name",
                            title: "On Demand",
                            content: "In this mode, the Internet connection will be terminated automatically after a specified time of inactivity (Max Idle Time) has elapsed. The connection is re-established when you attempt to access the Internet again."
                        }, {
                            type: "name",
                            title: "Manually",
                            content: "In this mode, the Internet connection is controlled manually by clicking the Connect or Disconnect button. This mode also supports the Max Idle Time function. Enter a maximum time (in minutes) the Internet connection can be inactive before it is terminated into the Max Idle Time field. The default value is 15 minutes. If you want the Internet connection remains active at all time, enter 0 (zero)."
                        }
                    ]
                }
            ]
        },

        HELP_PLC_STATION: {
            TITLE: "Powerline Device List",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays information of all powerline devices belong to the same network on the same electrical circuit."
                }, {
                    type: "name",
                    title: "Local Device",
                    content: "The powerline extender that you are currently logged into."
                }, {
                    type: "step",
                    content: ["In the list of powerline devices, MAC address and data transmitting rate of the corresponding device are displayed from left to right.", "Click the <b>Trash</b> icon to remove the corresponding powerline device from this network.", "Click the <b>Plus</b> icon to add a new powerline extender using its device password to the powerline network."]
                }, {
                    type: "name",
                    title: "Back",
                    content: "Click to go back to the Status page."
                }, {
                    type: "name",
                    title: "Refresh",
                    content: "Click to refresh the page."
                }
            ]
        },

        INTERNET_MAC: {
            TITLE: "MAC Clone",
            CONTENT: [
                {
                    type: "name",
                    title: "Use Default MAC Address",
                    content: "Do NOT change the default MAC address of the router, in case the ISP does not bind the assigned IP address to the MAC address."
                }, {
                    type: "name",
                    title: "Use Current Computer MAC Address",
                    content: "Select to copy the current MAC address of the computer that is connected to the router, in case the ISP binds the assigned IP address to the computer's MAC address."
                }, {
                    type: "name",
                    title: "Use Custom MAC Address",
                    content: "Enter the MAC address manually, in case the ISP binds the assigned IP address to the specific MAC address."
                }
            ]
        },

        LAN_IPV4: {
            TITLE: "LAN Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "LAN Type",
                    content: "Select Dynamic IP or Static IP."
                }, {
                    type: "name",
                    title: "Dynamic IP",
                    content: "Select this option to automatically obtain an IP address from the DHCP server."
                }, {
                    type: "name",
                    title: "Static IP",
                    content: "Select this option to manually specify the IP address, subnet mask, and default gateway."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "Displays the default extender's IP address, which is used to log in to the extender's web management page, and can be overridden."
                }, {
                    type: "name",
                    title: "Subnet Mask",
                    content: "Select an assigned identifier used by the LAN port to route Internal and External traffic from the drop-down list or enter a new subnet mask in dotted decimal format."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "The IP address used to connect the extender to the network."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save all your settings."
                }
            ]
        },

        LED_TIME: {
            TITLE: "LED Schedules",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "LED Schedules allow you to turn On (or Off) the LEDs on this powerline extender according to a specific time schedule."
                }, {
                    type: "name",
                    title: "LED Scheduler",
                    content: "Toggle <b>On</b> to enable the LED Scheduler feature."
                }
            ]
        },

        LED_TIME_GRID: {
            TITLE: "LED Off Schedules",
            CONTENT: [
                {
                    type: "name",
                    title: "From",
                    content: "Displays the time when the LED is Off."
                }, {
                    type: "name",
                    title: "To",
                    content: "Displays the time when the LED is back On again."
                }, {
                    type: "name",
                    title: "Day(s)",
                    content: "Displays the effective day(s) of the schedule."
                }, {
                    type: "name",
                    title: "Status",
                    content: " Indicates the current status of the corresponding schedule. Click the <b>Bulb</b> icon to enable (or disable) the schedule."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to <b>Modify</b> or <b>Delete</b> the corresponding schedule."
                }, {
                    type: "step",
                    title: "To create a new schedule",
                    content: ["1. Click <b>Add</b>.", "2. Specify a time range during which the LED will be off.", "3.  Select the day(s) of the week when this schedule is effective.", "4. Select <b>Enable this entry</b>.", "5. Click <b>OK</b> to save the settings."]
                }, {
                    type: "paragraph",
                    content: "To modify or delete a schedule, simply click the <b>Edit</b> icon to edit the information or the <b>Trash</b> icon to remove the corresponding schedule."
                }, {
                    type: "paragraph",
                    content: "To delete multiple schedules, select the corresponding checkbox of the schedules to be deleted and click <b>Delete</b> above the table."
                }
            ]
        },

        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "MAC Address",
                    content: "The unique physical address assigned to the powerline device."
                }, {
                    type: "name",
                    title: "Powerline Key",
                    content: "The unique key of this powerline device that is used when being added to a powerline network. The password is also printed on the product label."
                }, {
                    type: "name",
                    title: "Network Name ",
                    content: "Displays the powerline network name that the powerline extender belongs to. You can rename the network here or click Default to reset it back to the factory default name, i.e. HomePlugAV. Please note that if the factory default name is being used, the Wi-Fi Move feature will be automatically disabled."
                }
            ]
        },

        IPTV: {
            TITLE: "Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "Select to enable the IPTV feature."
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Select the appropriate mode according to your ISP. There are six supported IPTV modes:",
                    children: [
                        {
                            type: "name",
                            title: "Bridge",
                            content: " If your ISP is not listed and no other parameters are required, you can simply select this mode and configure the LAN port features of the router.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Assign your LAN port whether to function as the Internet supplier or as the IPTV supplier."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Russia",
                            content: "Select if your ISP is from Russia and the necessary parameters are predetermined, including Internet/IP-Phone/IPTV VLAN IDs and Priority, and LAN (1/2/3/4) port features.",
                            children: [
                                {
                                    type: "name",
                                    title: "IPTV Multicast Vlan ID/Priority",
                                    content: "You can enable the IPTV multicast feature as desired, and configure the VLAN ID and Priority according to your ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapore-ExStream",
                            content: "Select if your ISP is ExStream from Singapore and the necessary parameters are predetermined, including Internet/IPTV Vlan IDs and priority, and LAN (1/2/3/4)port features."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Select if your ISP is Unifi from Malaysia and the necessary parameters are predetermined, including Internet/IPTV Vlan IDs and priority, and LAN (1/2/3/4) port features."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Select if your ISP is Maxis from Malaysia and the necessary parameters are predetermined, including Internet/IP-Phone/IPTV VLAN IDs and Priority, and LAN (1/2/3/4) port features."
                        }, {
                            type: "name",
                            title: "Custom",
                            content: "Select if your ISP is not listed but provides the necessary parameters, including Internet/IP-Phone/IPTV VLAN IDs and Priority, and LAN (1/2/3/4) port features.",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/IP-Phone/IPTV Vlan ID/Priority",
                                    content: "Configure the VLAN IDs as provided by your ISP."
                                }, {
                                    type: "name",
                                    title: "802.11Q Tag",
                                    content: "Select whether to tag the Internet packets with 802.11Q."
                                }, {
                                    type: "name",
                                    title: "IPTV Multicast Vlan ID/Priority",
                                    content: "You can enable the IPTV multicast feature as desired, and configure the VLAN ID and Priority according to your ISP."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Assign your LAN port to whether function as the Internet supplier or as the IPTV supplier."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "IGMP Proxy",
                    content: "Select the IGMP (Internet Group Management Protocol) Proxy version, either V2 or V3, according to your ISP."
                }
            ]
        },

        DHCP_SERVER_SETTINGS: {
            TITLE: "Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "DHCP Server",
                    content: "By default, the DHCP (Dynamic Host Configuration Protocol) Server is enabled; it dynamically assigns TCP/IP parameters to client devices from the IP Address Pool. Do NOT disable the DHCP Server unless you have another DHCP server or you wish to manually assign the TCP/IP parameters to every client device on your network."
                }, {
                    type: "name",
                    title: "IP Address Pool",
                    content: "Enter the range of IP addresses that can be leased to the clients."
                }, {
                    type: "name",
                    title: "Address Lease Time",
                    content: "Enter the time duration that an IP address is leased to the client between 2 and 2880 minutes. The default is 120 minutes."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "Enter the LAN IP address. (Optional)"
                },
                /*{
				type: "name",
				title: "Default Domain",
				content: "(Optional) Enter the domain name of your network."
			},*/
                {
                    type: "name",
                    title: "Primary DNS/Secondary DNS",
                    content: "Enter these parameters as provided by your ISP. (Optional)"
                    /*children: [{
					type: "note",
					title: "Note",
					content: "If you encounter “Address not found” errors after entering the DNS addresses, it is likely that your DNS servers are setup incorrectly; contact your ISP for assistance."
				}]*/
                }
            ]
        },

        RESERVED_IP_ADDRESS: {
            TITLE: "Address Reservation",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "You can manually reserve an IP address for a client that is connected to the router. Once reserved, the IP address will only be assigned to the same client by the DHCP server."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the client with DHCP reserved IP address."
                }, {
                    type: "name",
                    title: "Reserved IP Address",
                    content: "Displays the reserved IP address of the client."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Displays a description of the client device."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the current status (enabled or disabled) of the client device."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify or Delete the corresponding client."
                }, {
                    type: "step",
                    title: "To reserve an IP address",
                    content: [
                        "1.	Click Add.",
                        "2.	Enter the MAC address of your desired client.",
                        "3.	Enter the IP address that you want to reserve for the client.",
                        "4.	Enter a description for the client.",
                        "5.	Select Enable.",
                        "6.	Click OK."
                    ]
                }, {
                    type: "step",
                    title: "To modify or delete an existing client",
                    content: "In the table, click the Edit icon or the Delete icon that corresponds to the client that you wish to modify or delete."
                }
            ]
        },

        DHCP_CLIENT_LIST: {
            TITLE: "DHCP Client List",
            CONTENT: [
                {
                    type: "name",
                    title: "Client Number",
                    content: "Displays the number of the associated DHCP client."
                }, {
                    type: "name",
                    title: "Client Name",
                    content: "Displays the name of the DHCP client."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address."
                }, {
                    type: "name",
                    title: "Assigned IP Address",
                    content: "Displays the allocated IP address to the client by the DHCP server."
                }, {
                    type: "name",
                    title: "Lease Time",
                    content: "Displays the time duration of the IP address that has been leased to the client."
                }, {
                    type: "name",
                    title: "Refresh",
                    content: "Click to update the DHCP Client List."
                }
            ]
        },

        DDNS: {
            TITLE: "Dynamic DNS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Dynamic DNS allows you to assign a fixed host and domain name to a dynamic Internet IP address. It is useful when you are hosting your own website, FTP server, or another server behind the router. First, you need to sign up with a DDNS service provider such as www.dyndns.com."
                }, {
                    type: "step",
                    title: "To set up a Dynamic DNS",
                    content: ["1. Select your DDNS service provider.", "2. Enter the Username and Password of your DDNS account.", "3. Enter the Domain Name you received from the DDNS service provider.", "4. Select your Update Interval from the drop-down list.", "5. Click Login and Save."]
                }, {
                    type: "paragraph",
                    content: "To switch between accounts, you must first Logout the current account and then Login another account with the new username and password."
                }
            ]
        },

        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Static Routing",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Static routing is used to predetermine a fixed route for the network information packets to reach a specific host or network."
                }, {
                    type: "step",
                    title: "To set up a Static Routing",
                    content: [
                        "1. Click Add.",
                        "2. Destination Network - Enter an IP address in hexadecimal to assign the static route for this entry.",
                        "3. Subnet Mask - Enter a subnet mask in hexadecimal format to determine the network portion and host portion of the IP address.",
                        "4. Default Gateway - Enter a gateway IP address in hexadecimal format to connect the router to the network or host.",
                        "5. Interface - Select LAN or WAN to specify the type of the Destination Network.",
                        "6. Description - Enter a brief description for this entry.",
                        "7. Select Enable.",
                        "8. Click OK."
                    ]
                }, {
                    type: "step",
                    title: "To modify or delete an existing entry",
                    content: "In the table, click the Edit icon or the Delete icon that corresponds to the entry that you wish to modify or delete."
                }
            ]
        },

        ADVANCED_ROUTING_SYSTEM_ROUTING_TABLE: {
            TITLE: "System Routing Table",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "System Routing Table displays all valid route entries that are currently in use."
                }, {
                    type: "paragraph",
                    content: "Click Refresh to update the Routing table."
                }
            ]
        },

        WIRELESS_REGION: {
            TITLE: "Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "Region",
                    content: " Select your region from the drop-down menu. If your country or region is not listed, it may be restricted to use the wireless radio in your location."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save all your settings."
                }
            ]
        },

        WIRELESS_BOTH: {
            TITLE: "Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The instructions below are for <span class=\"anti_5g\">both 2.4GHz and 5GHz </span>wireless networks."
                }, {
                    type: "name",
                    title: "Enable Wireless Radio",
                    content: "Select this checkbox to enable the wireless radio frequency."
                }, {
                    type: "name",
                    title: "Network Name (SSID)",
                    content: "You can leave the default Network Name (SSID) as is, or create a new name (up to 32 characters). This field is case-sensitive."
                }, {
                    type: "name",
                    title: "Hide SSID",
                    content: "Select this checkbox if you want to hide the corresponding network name (SSID) from the Wi-Fi network list."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create a wireless password between 8 and 63 ASCII characters, or between 8 and 64 hexadecimal characters to secure this wireless network."
                }, {
                    type: "name",
                    title: "Advanced",
                    content: "Click to display more advanced settings."
                }, {
                    type: "name",
                    title: "Security",
                    content: "Select one of the following security options:",
                    children: [
                        {
                            type: "name",
                            title: "No Security",
                            content: "Select this option to disable the wireless security. It is <b>highly recommended</b> that you enable the wireless security to protect your wireless network from unauthorized access."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Select this option to enable the standard authentication method based on a Pre-shared Key (PSK), also called passphrase. This option is recommended. If selected, configure the following.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Select a security version for your wireless network.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "This option supports multiple implementation of the WPA (Wi-Fi Protected Access) standard, such as WPA and WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "This option supports TKIP and AES encryptions."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "This option provides a better level of security than WPA-PSK and is recommended."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encryption",
                                    content: " Select a security encryption type: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), or <b>Auto</b> (for both TKIP and AES). It is <b>NOT</b> recommended to use the TKIP encryption if the powerline extender operates in 802.11n mode, because TKIP is not supported by 802.11n specification."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Select this option to enable the basic authentication method if any of your client devices can only access the wireless using WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Type",
                                    content: "Select an authentication type for your wireless network. The default is <b>Auto</b>, which automatically chooses <b>Open System</b> or <b>Shared Key</b> based on the capability and access request of the wireless client."
                                }, {
                                    type: "name",
                                    title: "Key Selected",
                                    content: "Select one of the four keys."
                                }, {
                                    type: "name",
                                    title: "WEP Key Format",
                                    content: "Either use <b>ASCII</b> or <b>Hexadecimal</b> format. ASCII format is a combination of alphabetic and numeric characters. Hexadecimal format is a combination of the number (0-9) and letters (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Key Type",
                                    content: "Select a WEP key length.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Allows you to enter 10 hexadecimal digits (0-9, A-F, a-f) or 5 ASCII characters into the password field."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Allows you to enter 26 hexadecimal digits (0-9, A-F, a-f) or 13 ASCII characters into the password field."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Select a transmission mixed mode."
                }, {
                    type: "name",
                    title: "Channel Width",
                    content: "Select a channel width (bandwidth) for the corresponding wireless network."
                }, {
                    type: "name",
                    title: "Channel",
                    content: "Select an operating channel for the corresponding wireless network. It is recommended to leave the channel to <b>Auto</b>, if you are not experiencing the intermittent wireless connection issue."
                }, {
                    type: "name",
                    title: "Transmit Power",
                    content: "Select either <b>High</b>, <b>Middle</b>, or <b>Low</b> to specify the data transmit power. The default and recommended setting is <b>High</b>."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save all your settings."
                }
            ]
        },

        WIRELESS_24G: {
            TITLE: "Wireless 2.4GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Enable Wireless Radio",
                    content: "Select this checkbox to enable the 2.4GHz wireless radio frequency."
                }, {
                    type: "name",
                    title: "Network Name (SSID)",
                    content: "You can leave the default Network Name (SSID) as it is, or enter a new name (up to 32 characters). This field is case-sensitive."
                }, {
                    type: "name",
                    title: "Hide SSID",
                    content: "Select this checkbox if you want to hide the 2.4GHz network name (SSID) from the Wi-Fi network list."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create a wireless password between 8 and 63 ASCII characters, or between 8 and 64 hexadecimal characters to secure this wireless network."
                }, {
                    type: "name",
                    title: "Advanced",
                    content: "Click to display more advanced settings."
                }, {
                    type: "name",
                    title: "Security",
                    content: "Select one of the following security options:",
                    children: [
                        {
                            type: "name",
                            title: "No Security",
                            content: "Select this option to disable the wireless security. It is <b>highly recommended</b> that you enable the wireless security to protect your wireless network from unauthorized access."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Select this option to enable the standard authentication method based on a Pre-shared Key (PSK), also called passphrase. This option is recommended. If selected, configure the following.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Select a security version for your wireless network.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "This option supports multiple implementation of the WPA (Wi-Fi Protected Access) standard, such as WPA and WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "This option supports TKIP and AES encryptions."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "This option supports AES encryption that provides a better level of security than WPA-PSK and is recommended."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encryption",
                                    content: "Select a security encryption type: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), or <b>Auto</b> (for both TKIP and AES). It is <b>NOT</b> recommended to use the TKIP encryption if the powerline extender operates in 802.11n mode, because TKIP is not supported by 802.11n specification."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Select this option to enable the basic authentication method if any of your client devices can only access the wireless using WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Type",
                                    content: "Select an authentication type for your wireless network. The default is <b>Auto</b>, which automatically chooses <b>Open System</b> or <b>Shared Key</b> based on the capability and access request of the wireless client."
                                }, {
                                    type: "name",
                                    title: "Key Selected",
                                    content: "Select one of the four keys."
                                }, {
                                    type: "name",
                                    title: "WEP Key Format",
                                    content: "Either use ASCII or Hexadecimal format. ASCII format is a combination of alphabetic and numeric characters. Hexadecimal format is a combination of the number (0-9) and letters (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Key Type",
                                    content: "Select a WEP key length.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Allows you to enter 10 hexadecimal digits (0-9, A-F, a-f) or 5 ASCII characters into the password field."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Allows you to enter 26 hexadecimal digits (0-9, A-F, a-f) or 13 ASCII characters into the password field."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Select a transmission mixed mode."
                }, {
                    type: "name",
                    title: "Channel Width",
                    content: "Select a channel width (bandwidth) for the 2.4GHz wireless network."
                }, {
                    type: "name",
                    title: "Channel",
                    content: "Select an operating channel for the 2.4GHz wireless network. It is recommended to leave the channel to <b>Auto</b>, if you are not experiencing the intermittent wireless connection issue."
                }, {
                    type: "name",
                    title: "Transmit Power",
                    content: "Select either <b>High</b>, <b>Middle</b>, or <b>Low</b> to specify the data transmit power. The default and recommended setting is <b>High</b>."
                }
            ]
        },

        WIRELESS_5G: {
            TITLE: "Wireless 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Enable Wireless Radio",
                    content: "Select this checkbox to enable the 5GHz wireless radio frequency."
                }, {
                    type: "name",
                    title: "Network Name (SSID)",
                    content: "You can leave the default Network Name (SSID) as is, or create a new name (up to 32 characters). This field is case-sensitive."
                }, {
                    type: "name",
                    title: "Hide SSID",
                    content: "Select this checkbox if you want to hide the 5GHz network name (SSID) from the Wi-Fi network list."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create a wireless password between 8 and 63 ASCII characters, or between 8 and 64 hexadecimal characters to secure this wireless network."
                }, {
                    type: "name",
                    title: "Advanced",
                    content: "Click to display more advanced settings."
                }, {
                    type: "name",
                    title: "Security",
                    content: "Select one of the following security options:",
                    children: [
                        {
                            type: "name",
                            title: "No Security",
                            content: "Select this option to disable the wireless security. It is <b>highly recommended</b> that you enable the wireless security to protect your wireless network from unauthorized access."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Select this option to enable the standard authentication method based on a Pre-shared Key (PSK), also called passphrase. This option is recommended. If selected, configure the following.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Select a security version for your wireless network.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "This option supports multiple implementation of the WPA (Wi-Fi Protected Access) standard, such as WPA and WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "This option supports TKIP and AES encryptions."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "This option supports AES encryption that provides a better level of security than WPA-PSK and is recommended."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encryption",
                                    content: "Select a security encryption type: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), or <b>Auto</b> (for both TKIP and AES). It is <b>NOT</b> recommended to use the TKIP encryption if the powerline extender operates in 802.11n mode, because TKIP is not supported by 802.11n specification."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Select this option to enable the basic authentication method if any of your client devices can only access the wireless using WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Type",
                                    content: "Select an authentication type for your wireless network. The default is <b>Auto</b>, which automatically chooses <b>Open System</b> or <b>Shared Key</b> based on the capability and access request of the wireless client."
                                }, {
                                    type: "name",
                                    title: "Key Selected",
                                    content: "Select one of the four keys."
                                }, {
                                    type: "name",
                                    title: "WEP Key Format",
                                    content: "Either use <b>ASCII</b> or <b>Hexadecimal</b> format. ASCII format is a combination of alphabetic and numeric characters. Hexadecimal format is a combination of the number (0-9) and letters (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Key Type",
                                    content: "Select a WEP key length.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Allows you to enter 10 hexadecimal digits (0-9, A-F, a-f) or 5 ASCII characters into the password field."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Allows you to enter 26 hexadecimal digits (0-9, A-F, a-f) or 13 ASCII characters into the password field."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Select a transmission mixed mode."
                }, {
                    type: "name",
                    title: "Channel Width",
                    content: "Select a channel width (bandwidth) for the 5GHz wireless network."
                }, {
                    type: "name",
                    title: "Channel",
                    content: "Select an operating channel for the 5GHz wireless network. It is recommended to leave the channel to Auto, if you are not experiencing the intermittent wireless connection issue."
                }, {
                    type: "name",
                    title: "Transmit Power",
                    content: "SSelect either High, Middle, or Low to specify the data transmit power. The default and recommended setting is High."
                }, {
                    type: "paragraph",
                    content: "Click Save to save all your settings."
                }
            ]
        },

        WIFI_TIME_CONTROL: {
            TITLE: "Wi-Fi Schedules",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi Schedules allows you to set specific times to turn the Wi-Fi off."
                }, {
                    type: "name",
                    title: "Wi-Fi Scheduler",
                    content: "Toggle <b>on</b> to enable the Wi-Fi Schedules feature. If you want the Wi-Fi to remain on while wireless devices are still connected to the wireless network, select the checkbox."
                }
            ]
        },

        WIFI_CLONE: {
            TITLE: "Wi-Fi Clone",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi Clone is used for copying the wireless settings (including SSID and wireless password) from the main wireless router to the extender."
                }, {
                    type: "name",
                    title: "Wi-Fi Band Selection",
                    content: "Select one <span class=\"anti_5g\">or both</span> to be cloned.<span class=\"anti_5g\">If the main router only supports the clone of one band at a time, we recommend that you choose 2.4GHz & 5GHz here to ensure that the cloned band is consistent with the band allowed by your router.</span>"
                }
            ]
        },

        WIFI_TIME_GRID: {
            TITLE: "Wi-Fi Off Schedules",
            CONTENT: [
                {
                    type: "name",
                    title: "From",
                    content: "Displays the time when the Wi-Fi is Off."
                }, {
                    type: "name",
                    title: "To",
                    content: " Displays the time when the Wi-Fi is back On again."
                }, {
                    type: "name",
                    title: "Day(s)",
                    content: "Displays the effective day(s) of the schedule."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Indicates whether the schedule is enabled or not. Click the Bulb icon to enable (or disable) the schedule."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to <b>Modify</b> or <b>Delete</b> the corresponding entry."
                }, {
                    type: "step",
                    title: "To add a new schedule",
                    content: ["1. Click <b>Add</b>.", "2. Specify a time range during which the Wi-Fi will turn off.", "3. Select the day(s).", "4. Select <b>Enable this entry</b>.", "5. Click <b>OK</b> to save this entry."]
                }, {
                    type: "paragraph",
                    content: "To modify or delete a Wi-Fi off entry, simply click the <b>Edit</b> icon to edit the information or the <b>Trash</b> icon to remove the corresponding entry."
                }, {
                    type: "paragraph",
                    content: "To delete multiple schedules, select all schedules and click <b>Delete</b> above the table."
                }
            ]
        },

        WPS: {
            TITLE: "Router's PIN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Other devices can connect to this router by WPS with Router's PIN."
                }, {
                    type: "name",
                    title: "Enable Router's PIN",
                    content: "Toggle On to allow wireless devices to connect to the router using the Router’s PIN (Personal Identification Number)."
                }, {
                    type: "name",
                    title: "Router's PIN",
                    content: "Displays the Router’s PIN. The default PIN can be found on the label of the router or in the User Guide. Click Generate to generate a new PIN randomly or click Default to restore the current PIN to the factory default PIN."
                }
            ]
        },

        WPS_WIZARD: {
            TITLE: "WPS Wizard",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Select a setup method"
                }, {
                    type: "name",
                    title: "Push Button (Recommended)",
                    content: "Select this setup method to enable the WPS feature to easily connect any WPS-enabled device to your wireless network using the WPS button or virtually using the Connect button."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Select this setup method to add a device manually by entering the wireless device's WPS PIN into the field and click Connect."
                }
            ]
        },

        WIRELESS_STATISTICS: {
            TITLE: "Online Wireless Clients",
            CONTENT: [
                {
                    type: "name",
                    title: "Total Clients",
                    content: "Displays the total number of wireless clients connected to the powerline network."
                }, {
                    type: "name",
                    title: "Device Name",
                    content: "Displays the name of the wireless client."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "Displays the IP address the wireless client is using."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the wireless client."
                }, {
                    type: "name",
                    title: "Wireless Band",
                    content: "Displays the frequency band <span class=\"anti_5g\">(2.4GHz or 5GHz) </span>of the wireless network that the wireless client is connected to."
                }, {
                    type: "name",
                    title: "Security",
                    content: "Displays the security type of the wireless client."
                }, {
                    type: "paragraph",
                    content: "Click <b>Refresh</b> to update the information on this page."
                }
            ]
        },

        GUEST_NETWORK_BASIC: {
            TITLE: "Guest Network",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b>Guest Network</b> allows you to have a separate wireless network name (SSID) and password that guests can use to access the Internet."
                }
            ]
        },

        GUEST_NETWORK_SETTINGS: {
            TITLE: "Guest Network",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b>Guest Network</b> allows you to have a separate wireless network name (SSID) and password that guests can use to access the Internet."
                }, {
                    type: "name",
                    title: "Allow guests to see each other",
                    content: "Select this checkbox to allow wireless devices on the Guest network to intercommunicate with each other."
                }, {
                    type: "name",
                    title: "Do not allow guests to manage my network",
                    content: "Select this option to prevent guests from logging into web management interfaces."
                }, {
                    type: "name",
                    title: "Automatic disable after",
                    content: "Select this option to automatically turn off the Guest Network based on the specific time."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save all your settings."
                }
            ]
        },

        GUEST_NETWORK_WIRELESS: {
            TITLE: "Guest Network Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "Toggle between 2.4GHz and 5GHz to display its settings."
                }, {
                    type: "name",
                    title: "Enable Guest Network",
                    content: "Select this checkbox to enable the Guest Network."
                }, {
                    type: "name",
                    title: "Network Name (SSID)",
                    content: "Either use the default Guest SSID or create a new name (up to 32 characters)."
                }, {
                    type: "name",
                    title: "Security",
                    content: "Select one of the following security options:",
                    children: [
                        {
                            type: "name",
                            title: "No Security",
                            content: "Select this option to disable the wireless security. It is <u><b>highly recommended</b></u> that you enable the wireless security to protect your Guest Network from unauthorized access."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Select this option to enable the standard authentication method based on a Pre-shared Key (PSK), also called passphrase. If selected, configure the following."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Password",
                    content: "Either use the default password or create a password between 8 and 63 ASCII characters or between 8 and 64 hexadecimal characters (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save your Guest Network wireless settings."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Guest Network Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "Enable Guest Network",
                    content: "Select this checkbox to enable the Guest Network."
                }, {
                    type: "name",
                    title: "Network Name (SSID)",
                    content: "Either use the default Guest SSID or create a new name (up to 32 characters)."
                }, {
                    type: "name",
                    title: "Security",
                    content: "Select one of the following security options:",
                    children: [
                        {
                            type: "name",
                            title: "No Security",
                            content: "Select this option to disable the wireless security. It is <u><b>highly recommended</b></u> that you enable the wireless security to protect your Guest Network from unauthorized access."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Select this option to enable the standard authentication method based on a Pre-shared Key (PSK), also called passphrase. If selected, configure the following."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Password",
                    content: "Either use the default password or create a password between 8 and 63 ASCII characters or between 8 and 64 hexadecimal characters (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save your Guest Network wireless settings."
                }
            ]
        },
        NAT: {
            TITLE: "Application Layer Gateway(ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG allows customized Network Address Translation (NAT) traversal filters to be plugged into the gateway to support address and port translation for certain application layer \"control/data\" protocols: FTP, TFTP, H323 etc. Enabling ALG is recommended."
                }, {
                    type: "name",
                    title: "Enable FTP ALG",
                    content: "If selected, it allows FTP(File Transfer Protocol) clients and servers to transfer data via NAT."
                }, {
                    type: "name",
                    title: "Enable TFTP ALG",
                    content: "If selected, it allows TFTP(Trivial File Transfer Protocol) clients and servers to transfer data via NAT."
                }, {
                    type: "name",
                    title: "Enable H323 ALG",
                    content: "If selected, it allows Microsoft NetMeeting clients to communicate via NAT."
                }, {
                    type: "name",
                    title: "Enable RTSP ALG",
                    content: "If selected, it allows media player clients to communicate with streaming media servers via NAT."
                }, {
                    type: "name",
                    title: "Enable PPTP Passthrough",
                    content: "If selected, it allows Point-to-Point sessions to be tunneled through an IP network and passed through the router."
                }, {
                    type: "name",
                    title: "Enable L2TP Passthrough",
                    content: "If selected, it allows Layer 2 Point-to-Point sessions to be tunneled through an IP network and passed through the router."
                }, {
                    type: "name",
                    title: "Enable IPSec Passthrough",
                    content: "If selected, it allows Internet Protocol security (IPSec) to be tunneled through an IP network and passed through the router. IPSec uses crytographic security services to ensure private and secure communications over IP networks."
                }, {
                    type: "paragraph",
                    content: "Click Save to save all your settings."
                }
            ]
        },

        VIRTUAL_SERVERS: {
            TITLE: "Virtual Servers",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Virtual Servers are used to set up public services on your local network. A virtual server is defined as an external port, and all requests from the Internet to this external port will be redirected to a designated computer, which must be configured with a static or reserved IP address."
                }, {
                    type: "name",
                    title: "Service Type",
                    content: "Displays the name of your virtual server."
                }, {
                    type: "name",
                    title: "External Port",
                    content: "Displays the port number or a range of ports used by the virtual server."
                }, {
                    type: "name",
                    title: "Internal IP",
                    content: "Displays the IP address of the computer running the service application."
                }, {
                    type: "name",
                    title: "Internal Port",
                    content: "Displays the port number of computer running the service application."
                }, {
                    type: "name",
                    title: "Protocol",
                    content: "Displays the protocol used for the service application: TCP, UDP, or All (All protocols supported by the router)."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the current status (enabled or disabled) of the specific filtering rule."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify or Delete the corresponding rule."
                }, {
                    type: "step",
                    title: "To set up a Virtual Server rule",
                    content: ["1.	Click Add.", "2. Click View Existing Services to select a service from the list to automatically populate the appropriate port number in the External Port and Internal Port fields. If the service is not listed, enter the external port number (e.g. 21) or a range of ports (e.g. 21-25). Leave the Internal Port blank if it is the same as the External Port or enter a specific port number (e.g. 21) if the External Port is a single port. Enter the IP address of the computer running the service application in the dotted decimal format into the Internal IP field.", "3.	Select a protocol for the service application: TCP, UDP, or All from the Protocol drop-down list.", "4.	Select Enable.", "5.	Click OK"]
                }, {
                    type: "step",
                    title: "To modify or delete a Virtual Server rule",
                    content: "Click the Modify icon or the Trash icon that corresponds to the rule that you wish to modify or delete."
                }, {
                    type: "step",
                    title: "To delete multiple rules",
                    content: "Select all the entries that you wish to delete, click Delete above the table."
                }, {
                    type: "note",
                    title: "Note",
                    content: "If your local host device is hosting more than one type of available services, you need to create a rule for each service."
                }
            ]
        },

        PORT_TRIGGERING: {
            TITLE: "Port Triggering",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Port Triggering is used to forward traffic on a certain port to specific server on the network."
                }, {
                    type: "name",
                    title: "Application",
                    content: "Displays the name of the application."
                }, {
                    type: "name",
                    title: "Triggering Port",
                    content: "Displays the outgoing traffic port used to trigger a filtering rule of an outgoing connection."
                }, {
                    type: "name",
                    title: "Trigger Protocol",
                    content: "Displays the protocol used for Triggering Port. TCP, UDP, or All (All protocols supported by the router)."
                }, {
                    type: "name",
                    title: "External Port",
                    content: "Displays the port or port range used by the remote system. A response using one of these ports will be forwarded to the PC which triggers this rule. You can input at most 5 groups of ports (or port sections). Every group of ports must be separated with “,” (commas), for example, 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "External Protocol",
                    content: "Displays the protocol used for Incoming Port: TCP, UDP, or ALL (All protocols supported by the router)."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the current status (enabled or disabled) of the specific filtering rule."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify or Delete and corresponding rule."
                }, {
                    type: "step",
                    title: "To set up a Port Triggering rule",
                    content: [
                        {
                            type: "note",
                            title: "Note",
                            content: "Each rule can only be used by one host at a time."
                        },
                        "1. Click Add.", {
                            content: "2. Click View Existing Applications to select an application from the list to automatically populate the default values into the appropriate fields. If you want to add an unlisted application, manually enter the Application, Triggering Port, Triggering Protocol, External Port and External Protocol.",
                            children: [
                                {
                                    type: "note",
                                    title: "Note",
                                    content: "Rules cannot have any port ranges overlap each other (e.g. Rule 1 has the port range 4200-4205, which means Rule 2 cannot have port range from 4203-4206)."
                                }
                            ]
                        },
                        "3. Select Enable.",
                        "4. Click OK."
                    ]
                }, {
                    type: "step",
                    title: "To modify or delete a Port Triggering rule",
                    content: "In the table, click the Modify icon or the Trash icon that corresponds to the rule that you wish to modify or delete."
                }, {
                    type: "step",
                    title: "To delete multiple Port Triggering rules",
                    content: "In the table, select all rules that you wish to delete, click Delete above the table."
                }
            ]
        },

        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The DMZ (Demilitarized Zone) host feature allows a local host to be exposed to the Internet for a special-purpose service, such as Internet gaming or video conferencing. Basically, the DMZ allows a single computer on your LAN to open all its ports. This computer needs to be configured with a static IP address and have its DHCP client function disabled."
                }, {
                    type: "step",
                    title: "To assign a computer or server to be a DMZ server",
                    content: ["1. Click Enable DMZ.", "2. In the DMZ Host IP Address field, enter the IP Address of a local computer to set up as the DMZ host.", "3. Click Save."]
                }
            ]
        },

        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "By default, the Universal Plug-and-Play (UPnP) feature is enabled to allow devices, such as computers and Internet appliances to automatically discover and communicate with each other on the local network."
                }, {
                    type: "paragraph",
                    content: "The UPnP Service List displays the UPnP device information."
                }, {
                    type: "name",
                    title: "Service Description",
                    content: "Displays a brief description of the local host that initiates the UPnP request."
                }, {
                    type: "name",
                    title: "External Port",
                    content: "Displays the external port that is opened by the local host."
                }, {
                    type: "name",
                    title: "Protocol",
                    content: "Displays the network protocol type that is used by the local host."
                }, {
                    type: "name",
                    title: "Internal IP Address",
                    content: "Displays the IP address of the local host."
                }, {
                    type: "name",
                    title: "Internal Port",
                    content: "Displays the internal port that is opened by the local host."
                }, {
                    type: "paragraph",
                    content: "Click Refresh to update the UPnP Server List."
                }
            ]
        },

        DISK_SETTING: {
            TITLE: "Device Settings",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The Device Settings page displays the related information of any connected USB storage device via the USB port."
                }, {
                    type: "name",
                    title: "Scan",
                    content: "Usually, the router automatically detects any newly attached device. If not, click this button to scan for any new connected device and refresh the page with the updated information."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Displays the name of the USB volume."
                }, {
                    type: "name",
                    title: "Capacity",
                    content: "Displays the total storage capacity of the USB."
                }, {
                    type: "name",
                    title: "Free Space",
                    content: "Displays the current available free storage space."
                }, {
                    type: "name",
                    title: "Safely Remove",
                    content: "Click this button to safely unmount the USB storage device before physically disconnecting it from the router."
                }, {
                    type: "paragraph",
                    content: "Please note that the Safely Remove button only appears when there is a USB storage device connected to the router, and you will not able to unmounts the USB device while the current volume is busy."
                }, {
                    type: "name",
                    title: "Active",
                    content: "This checkbox only appears when there is a USB storage device connected to the router. Select to enable file sharing of the USB device."
                }, {
                    type: "step",
                    title: "To set up a file server",
                    content: ["1. Attach the USB storage device to the USB port of the router using a USB cable.", "2. The newly attached USB device should be automatically detected by the router and displayed the information under the Device Settings section. If not, click Scan.", "3. Select Active to enable file sharing."]
                }
            ]
        },

        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Sharing Account",
            CONTENT: [
                {
                    type: "name",
                    title: "Account",
                    content: "You can either select to Use Default Account to login to the shared files and folders or Use New Account and enter the following to create a new user account."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter an alphanumeric or under line string of up to 15 characters in length. The username must start with an alphabet character. These fields are case-sensitive."
                }, {
                    type: "name",
                    title: "Confirm Password",
                    content: "Re-enter the password to confirm there is no typo. This field is also case-sensitive."
                }, {
                    type: "paragraph",
                    content: "Click Save to save the new user account."
                }
            ]
        },

        FOLDER_SHARE_SETTINGS: {
            TITLE: "Sharing Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "Network/Media Server Name",
                    content: "Displays the name used to access the connected USB storage device."
                }, {
                    type: "name",
                    title: "Enable",
                    content: "Select to enable the access method."
                }, {
                    type: "name",
                    title: "Access Method",
                    content: "There are three access methods to allow access to the attached USB storage device. You can choose one or more access methods by selecting the corresponding checkbox.",
                    children: [
                        {
                            type: "name",
                            title: "Network Neighborhood",
                            content: "If enabled, users on your network can access the USB storage device using an assigned IP address (e.g. \\\\192.168.0.1). This method is enabled by default."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "If enabled, the FTP clients on your local network can access the USB storage device using the assigned IP address, followed by the FTP server's port number (e.g. ftp://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (Via Internet)",
                            content: " If enabled, users can remotely access the USB storage drive through FTP over the Internet. This feature supports both downloading and uploading files. To change FTP server's port number, enter a port number and click Save to apply the changes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Link",
                    content: "Displays the address used to access the shared USB storage device."
                }, {
                    type: "name",
                    title: "Port",
                    content: "Displays the port number of the FTP server."
                }
            ]
        },

        FOLDER_SHARE_FOLDERS: {
            TITLE: "Folder Sharing",
            CONTENT: [
                {
                    type: "name",
                    title: "Share All",
                    content: "Toggle On to share all files and folders or Off to only share the selected folders."
                }, {
                    type: "name",
                    title: "Enable Authentication",
                    content: "It is strongly recommended to enable authentication to require users to enter the valid username and password to access the sharing folders."
                }, {
                    type: "name",
                    title: "Folder Name",
                    content: "Displays the name of the shared folder."
                }, {
                    type: "name",
                    title: "Folder Path",
                    content: "Displays the path to the shared folder."
                }, {
                    type: "name",
                    title: "Media Sharing",
                    content: "Indicates whether the shared folder is allowed for media sharing or not."
                }, {
                    type: "name",
                    title: "Volume Name",
                    content: "Displays the name of the shared volume."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the status of the shared folder by the light bulb indicator. Green (ON) is enabled and Grey (OFF) is disabled. You can enable or disable sharing by clicking the bulb."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify or Delete the corresponding shared folder."
                }, {
                    type: "name",
                    title: "Browse",
                    content: "Click to search for a sharing folder."
                }, {
                    type: "name",
                    title: "Allow Guest Network Access",
                    content: "Select to allow clients on Guest Network to access the shared folders."
                }, {
                    type: "name",
                    title: "Enable Authentication",
                    content: "Select to require users to access the shared folders with a valid username and password."
                }, {
                    type: "name",
                    title: "Enable Write Access",
                    content: "Select to allow users to make changes to the folder content."
                }, {
                    type: "name",
                    title: "Enable Media Sharing",
                    content: "Select to enable media sharing."
                }
            ]
        },

        PRINT_SERVER: {
            TITLE: "Print Server",
            CONTENT: [
                {
                    type: "step",
                    title: "To set up a Print Server that can be used across your network",
                    content: ["1. Connect a USB printer to the USB port of the router via a USB cable.", "2. Install the printer driver on your computer. Refer to the computer manufacturer’s manuals for instructions.", "3. Install the TP-LINK USB Printer Controller Utility, either from the Resource CD (for Windows only) or download it (for both Windows and Mac OS X) from TP-LINK’s official website."]
                }
            ]
        },

        PARENTAL_CONTROL: {
            TITLE: "Parental Controls",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "With Parental Controls, you can set time limits to wireless devices and control when these devices can access the Internet."
                }, {
                    type: "name",
                    title: "Parental Controls",
                    content: "Toggle <b>On</b> to enable the Parental Controls feature."
                }
            ]
        },

        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Devices Under Parental Controls",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Displays the ID of the client device."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the client device."
                }, {
                    type: "name",
                    title: "Internet Access Time",
                    content: "Displays the permitted access time periods."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Displays a brief description of the connected device."
                }, {
                    type: "name",
                    title: "Status",
                    content: " Indicates whether or not Parental Controls is turned on for the corresponding device."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to <b>Modify</b> or <b>Delete</b> the device."
                }, {
                    type: "step",
                    title: "To set time limit to a new client device",
                    content: [
                        "1. Click <b>Add</b>.",
                        "2. Click <b>View Existing Devices</b> and choose a currently connected device from the <b>Wireless Access Device</b> List; or enter the <b>MAC Address</b> manually to add a device that is not connected.",
                        "3. Click the <b>Internet Access Time</b> icon to specify time ranges during which the device is allowed to access the Internet.",
                        "4. Enter a brief description into the <b>Description</b> field. This field is optional.",
                        "5. Select <b>Enable this Entry</b>.",
                        "6. Click <b>OK</b> to save this entry."
                    ]
                }, {
                    type: "paragraph",
                    content: "To modify or delete a device from the list, simply click the <b>Edit</b> icon to edit the information or the <b>Trash</b> icon to remove the corresponding entry."
                }, {
                    type: "paragraph",
                    content: "To delete multiple devices from the list, select the corresponding checkbox of the devices to be deleted and click <b>Delete</b> above the table."
                }
            ]
        },

        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Content Restriction",
            CONTENT: [
                {
                    type: "name",
                    title: "Blacklist",
                    content: "Contains keywords that will be used to block any website access from client devices specified in the Parental Control list.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Click Add a New Keyword to add a keyword to the blacklist. To delete a keyword, click the (-) icon of the keyword that you wish to delete."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Whitelist",
                    content: "Contains website addresses that client devices specified in the Parental Control list are allowed to access.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Click Add a New Domain Name to add a website to the whitelist. To delete a website, click the (-) icon of the website that you wish to delete."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Note",
                    content: "Keywords can also be domain names, for example, www.mail.google.com or www.facebook.com."
                }, {
                    type: "paragraph",
                    content: "Click Save to save your configuration."
                }
            ]
        },

        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The Quality of Service (QoS) helps to prioritize the Internet traffic based-on your needs. You can specify the priority level for a device or an application in the QoS rules list."
                }, {
                    type: "note",
                    title: "Note",
                    content: "If NAT Boost is enabled, QoS should be disabled."
                }, {
                    type: "name",
                    title: "Enable QoS",
                    content: "Click this box to enable the QoS function."
                }, {
                    type: "name",
                    title: "Upload Bandwidth",
                    content: "Enter the maximum upload bandwidth provided by your ISP (Internet Service Provider)."
                }, {
                    type: "name",
                    title: "Download Bandwidth",
                    content: "Enter the maximum download bandwidth provided by your ISP."
                }, {
                    type: "name",
                    title: "High Priority Guarantee",
                    content: "Specify a percentage for the high priority traffic."
                }, {
                    type: "name",
                    title: "Middle Priority Guarantee",
                    content: "Specify a percentage for the middle priority traffic."
                }, {
                    type: "name",
                    title: "Low Priority Guarantee",
                    content: "Specify a percentage for the low priority traffic."
                }, {
                    type: "note",
                    title: "Note",
                    content: "The amount (percentage) of all priorities should be 1."
                }, {
                    type: "paragraph",
                    content: "Click Save to save all your settings."
                }
            ]
        },

        QOS_RULE: {
            TITLE: "QoS Rules List",
            CONTENT: [
                {
                    type: "name",
                    title: "Type",
                    content: "Select a type to add the QoS rule list."
                }, {
                    type: "step",
                    title: "To set up a rule for high/middle/low priority By Device",
                    content: ["1. Click Add.", "2. Select By Device.", "3. Click View Existing Devices to select your desired device from the Access Devices List, or you can enter a device name and its MAC address manually into the Device Name and MAC Address fields.", "4. Click OK."]
                }, {
                    type: "step",
                    title: "To set up a rule for high/middle/low priority By Application",
                    content: ["1. Click Add.", "2. Select By Application.", "3. Select your desired application from the Application list, or you can customize an application by configuring the name, protocol and port in the corresponding fields.", "4. Click OK."]
                }, {
                    type: "step",
                    title: "To set up a rule for high/middle/low priority By Physical Port",
                    content: ["1. Click Add.", "2. Select By Physical Port.", "3. Select your desired port.", "4. Click OK."]
                }
            ]
        },

        QOS_DATABASE: {
            TITLE: "Database Upgrade",
            CONTENT: [
                {
                    type: "name",
                    title: "New Database File",
                    content: "Click Browse to locate your new database file. Select and click Upgrade to upgrade your database to a newer version."
                }, {
                    type: "name",
                    title: "Database Version",
                    content: "Displays the current database version."
                }
            ]
        },

        SECURITY_FIREWALL: {
            TITLE: "Firewall",
            CONTENT: [
                {
                    type: "name",
                    title: "SPI Firewall",
                    content: "Stateful Packet Inspection (SPI) firewall prevents cyber attacks and validates the traffic that is passing through the router based on the protocol. The SPI Firewall is enabled by default. "
                }
            ]
        },

        SECURITY_DOS: {
            TITLE: "DoS Protection",
            CONTENT: [
                {
                    type: "name",
                    title: "DoS Protection",
                    content: "Denial of Service (DoS) protection protects your LAN against DoS attacks from flooding your network with server requests. By default, DoS Protection is disabled (Off)."
                }, {
                    type: "name",
                    title: "ICMP-FLOOD Attack Filtering",
                    content: "Enable to prevent the Internet Control Message Protocol (ICMP) flood attack."
                }, {
                    type: "name",
                    title: "UDP-FLOOD Attack Filtering",
                    content: "Enable to prevent the User Datagram Protocol (UDP) flood attack."
                }, {
                    type: "name",
                    title: "TCP-SYN-FLOOD Attack Filtering",
                    content: "Enable to prevent the Transmission Control Protocol-Synchronize (TCP-SYN) flood attack.",
                    children: [
                        {
                            type: "name",
                            title: "Off",
                            content: "No protection."
                        }, {
                            type: "name",
                            title: "Low",
                            content: "Low-level of protection and low impact on router performance."
                        }, {
                            type: "name",
                            title: "Middle",
                            content: "Moderate-level of protection and semi-noticeable impact on router performance."
                        }, {
                            type: "name",
                            title: "High",
                            content: "High-level of protection but a noticeable impact on router performance."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignore Ping Packet From WAN Port",
                    content: "Enable to ignore ping packets from the WAN port."
                }, {
                    type: "name",
                    title: "Forbid Ping Packet From LAN Port",
                    content: "Enable to forbid ping packets from the LAN port."
                }
            ]
        },

        MAC_FILTER_ALL: {
            TITLE: "MAC Filter",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC Filtering is used to allow or block specific computers and other devices from accessing your network. When a device is blocked, it is unable to connect to the powerline device."
                }, {
                    type: "name",
                    title: "MAC Filter Settings",
                    children: [
                        {
                            type: "name",
                            title: "MAC Filter",
                            content: "Toggle <b>On</b> to enable this feature. If the feature is disabled (Off), all devices are allowed to connect."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Select the filtering rule",
                    content: "Select to either block or allow client devices listed under the Device List to access the wireless network. Click <b>Save</b> to save your settings."
                }, {
                    type: "name",
                    title: "Device List",
                    children: [
                        {
                            type: "step",
                            title: "To add a client device",
                            content: ["1. Click <b>Add</b>.", "2. Click <b>View Devices</b> and choose the device's MAC address from the list, or enter the MAC address manually.", "3. Give a brief description for the device.", "4. Select <b>Enable this entry</b>.", "5. Click <b>OK</b>."]
                        }, {
                            type: "step",
                            title: "To modify or delete a client device",
                            content: "Click the <b>Edit</b> icon or the <b>Trash</b> icon that corresponds to the device that you wish to modify or delete."
                        }, {
                            type: "step",
                            title: "To delete multiple devices in the Device List",
                            content: "Select the corresponding check box of the devices to be deleted, and click <b>Delete</b> above the table."
                        }
                    ]
                }
            ]
        },

        MAC_FILTER: {
            TITLE: "MAC Filter",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC Filtering is used to allow or block specific computers and other devices from accessing your network. When a device is blocked, it is unable to connect to the powerline device."
                }, {
                    type: "name",
                    title: "MAC Filter Settings",
                    children: [
                        {
                            type: "name",
                            title: "MAC Filter",
                            content: "Toggle <b>On</b> to enable this feature. If the feature is disabled (Off), all devices are allowed to connect."
                        }
                    ]
                }
            ]
        },

        MAC_FILTER_RULES: {
            TITLE: "Select the filtering rule",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Select to either block or allow client devices listed under the Device List to access the wireless network."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save your settings."
                }
            ]
        },

        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Device List",
            CONTENT: [
                {
                    type: "step",
                    title: "To add a client device",
                    content: ["1. Click <b>Add</b>.", "2. Click <b>View Devices</b> and choose the device's MAC address from the list, or enter the MAC address manually.", "3. Give a brief description for the device.", "4. Select <b>Enable this entry.</b>", "5. Click <b>OK</b>."]
                }, {
                    type: "step",
                    title: "To modify or delete a device in the Device List",
                    content: "Click the <b>Edit</b> icon or the <b>Trash</b> icon that corresponds to the device that you wish to modify or delete."
                }, {
                    type: "step",
                    title: "To delete multiple devices in the Device List",
                    content: "Select the corresponding check box of the devices to be deleted, and click <b>Delete</b> above the table."
                }
            ]
        },

        WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "With the Wi-Fi Move feature enabled, any changes made to the Wi-Fi settings of one powerline extender will automatically synchronize to other powerline extenders  on the same powerline network whose Wi-Fi Move feature is also enabled.Please note that if the factory default name, i.e. HomePlugAV, is being used, the Wi-Fi Move feature will be automatically disabled."
                }, {
                    type: "name",
                    title: "Wi-Fi Move",
                    content: "Toggle <b>On</b> to enable this feature."
                }
            ]
        },

        SECURITY_LIST: {
            TITLE: "Blocked DoS Host List",
            CONTENT: [
                {
                    type: "name",
                    title: "Blocked DoS Host List",
                    content: "Lists the IP Address and MAC Address from any blocked DoS attack source."
                }, {
                    type: "step",
                    title: "To delete an entry",
                    content: "In the Host List, select the entry that you wish to delete and click Delete above the table."
                }
            ]
        },

        ACCESS_CONTROL: {
            TITLE: "Access Control",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Access Control is used to allow or block specific computers and other devices from accessing your network. When a device is blocked, it is able to get an IP address from the router, but unable to communicate with other devices or connect to the Internet."
                }, {
                    type: "paragraph",
                    content: "To use the Access Control, enable this feature and specify a black or white list. If the Access Control is disabled (Off), all devices, including the blacklisted ones, are allowed to connect."
                }
            ]
        },

        ACCESS_MODE: {
            TITLE: "Access Mode",
            CONTENT: [
                {
                    type: "name",
                    title: "Blacklist",
                    content: "Only the devices on the Blacklist will be denied to access your network."
                }, {
                    type: "name",
                    title: "Whitelist",
                    content: "Only the devices on the Whitelist will be allowed to access your network."
                }
            ]
        },

        ACCESS_DEVICE: {
            TITLE: "Devices Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Device Name",
                    content: "Displays the name of the connected device."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "Displays the IP address of the connected device."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the connected device."
                }, {
                    type: "name",
                    title: "Connection Type",
                    content: "Displays the connection type of the connected device."
                }, {
                    type: "step",
                    title: "To block a device",
                    content: "In the Devices Online table, click the Block icon in the Modify column that corresponds to the device that you wish to block."
                }, {
                    type: "step",
                    title: "To block multiple devices",
                    content: "In the Devices Online table, select all devices that you wish to block, click Block above the table. The device will be automatically added to the Devices in Blacklist or Whitelist."
                }
            ]
        },

        ACCESS_LIST: {
            TITLE: "Devices in Black/WhiteList",
            CONTENT: [
                {
                    type: "step",
                    title: "To blacklist or whitelist a device",
                    content: ["1. Click the Add icon.", "2. Enter the Device Name.", "3. Enter the MAC address of the device.", "4.  Click OK."]
                }, {
                    type: "step",
                    title: "To modify or delete a device in the Black/Whitelist",
                    content: "In the Black/Whitelist table, click the Modify icon or the Delete icon that corresponds to the device that you wish to modify or delete."
                }, {
                    type: "step",
                    title: "To delete multiple devices in the Black/Whitelist",
                    content: "In the Black/Whitelist table, select all devices that you wish to delete, click Delete above the list."
                }
            ]
        },

        IPMAC_BIND_SETTING: {
            TITLE: "Settings",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ARP (Address Resolution Protocol) binding is useful for controlling access of a specific computer in the LAN by binding the IP address and the MAC address of the device together. ARP binding also prevents other devices from using a specific IP address."
                }
            ]
        },

        IPMAC_BIND_ARP: {
            TITLE: "ARP List",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays the MAC and IP addresses of the currently connected devices."
                }, {
                    type: "name",
                    title: "ARP Entry Number",
                    content: "Displays the total number of devices that are currently connected to the router."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the connected device."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "Displays the IP address allocated to the connected device."
                }, {
                    type: "name",
                    title: "Bound",
                    content: "Indicates whether the MAC and IP addresses are bound or not."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Bind or Delete the corresponding entry from the list."
                }, {
                    type: "note",
                    title: "Note",
                    content: "You cannot bind the same IP address to more than one MAC address."
                }
            ]
        },

        IPMAC_BIND_LIST: {
            TITLE: "Binding List",
            CONTENT: [
                {
                    type: "step",
                    title: "To set up a device with ARP binding",
                    content: [
                        "1. Click Add.",
                        "2. Enter the MAC Address of the device.",
                        "3. Enter an IP Address that you want bind to the above MAC address.",
                        "4. Enter a Description for this device. (Optional)",
                        "5. Select Enable.",
                        "6. Click OK."
                    ]
                }, {
                    type: "step",
                    title: "To modify or delete an entry",
                    content: "In the Binding List, click the Modify icon or the Delete icon that corresponds to the entry that you wish to modify or delete."
                }, {
                    type: "step",
                    title: "To delete multiple entries",
                    content: "In the Binding List, select all the entries that you wish to delete, click Delete above the list."
                }
            ]
        },

        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Select to enable (On) or disable (Off) the IPv6 feature of the router."
                }, {
                    type: "title",
                    title: "Internet Connection Type: Static IP"
                }, {
                    type: "name",
                    title: "Static IP",
                    content: "Select this type if your ISP uses Static IPv6 address assignment."
                }, {
                    type: "name",
                    title: "IPv6 Address/Default Gateway/Primary DNS/Secondary DNS",
                    content: "Enter these parameters as provided by the ISP."
                }, {
                    type: "name",
                    title: "MTU Size",
                    content: "The default and typical MTU (Maximum Transmission Unit) size for most Ethernet networks is 1500 Bytes. It is NOT recommended to change the default MTU size unless required by the ISP."
                }, {
                    type: "title",
                    title: "Internet Connection Type: Dynamic IP"
                }, {
                    type: "name",
                    title: "Dynamic IP",
                    content: "Select this type if your ISP uses Dynamic IPv6 address assignment."
                }, {
                    type: "name",
                    title: "IPv6 Address/Primary DNS/Secondary DNS",
                    content: "These parameters are automatically assigned by the DHCPv6 server from your ISP."
                }, {
                    type: "name",
                    title: "Renew",
                    content: "Click this button to get new IPv6 parameters from the DHCPv6 server of the ISP."
                }, {
                    type: "name",
                    title: "Release",
                    content: "Click this button to release all IPv6 addresses assigned by DHCPv6 server from the ISP."
                }, {
                    type: "name",
                    title: "Get IPv6 Address",
                    content: "Select to “Get non-temporary IPv6 address” or “Get IPv6 prefix delegation”, according to your ISP."
                }, {
                    type: "name",
                    title: "DNS Address",
                    content: "Select to “Get dynamically from ISP” or “Use the following DNS address”. If “Use the following DNS Address” is selected, please manually enter the DNS address provided by your ISP."
                }, {
                    type: "name",
                    title: "Primary DNS/Secondary DNS",
                    content: "Enter these parameters manually or dynamically obtain them from the ISP."
                }, {
                    type: "title",
                    title: "Internet Connection Type: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Select this type if your ISP uses PPPoEv6, and provides you with a username and password."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter these parameters as provided by your ISP."
                }, {
                    type: "name",
                    title: "IPv6 Address",
                    content: "It will be automatically assigned by DHCPv6 server from the ISP, after you enter the username and password and click Connect."
                }, {
                    type: "name",
                    title: "DNS Address",
                    content: "Select to “Get dynamically from ISP” or “Use the following DNS address”. If “Use the following DNS Address” is selected, please manually enter the DNS address provided by your ISP."
                }, {
                    type: "name",
                    title: "Get IPv6 Address",
                    content: "Select “Non-temporary” or “Prefix delegation” or “Specified by ISP” according to your ISP. If selecting “Specified by ISP”, you need to manually enter the IPv6 address as provided by your ISP. If you select “Non-temporary” or “Prefix delegation”, the IPv6 address will be automatically assigned by the DHCPv6 server from the ISP.",
                    children: [
                        {
                            type: "name",
                            title: "Non-temporary",
                            content: "Get a non-temporary IPv6 address by DHCPv6 Server from the Internet Service Provider(ISP)."
                        }, {
                            type: "name",
                            title: "Prefix delegation",
                            content: "Get a prefix delegation IPv6 address by DHCPv6 Server from the ISP, and the client in LAN create a IPv6 address with the delegation."
                        }, {
                            type: "name",
                            title: "Specified by ISP",
                            content: "Use a static IPv6 address specified by the ISP."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Connect",
                    content: "Click this button to get Internet connection."
                }, {
                    type: "name",
                    title: "Disconnect",
                    content: "Click this button to disconnect from the Internet."
                }, {
                    type: "title",
                    title: "Internet Connection Type: 6to4 Tunnel"
                }, {
                    type: "name",
                    title: "6to4 Tunnel",
                    content: "Select this type if your ISP uses 6to4 deployment for assigning address."
                }, {
                    type: "name",
                    title: "IPv4 Address/IPv4 Subnet Mask/IPv4 Default Gateway/Tunnel Address",
                    content: "These parameters will be dynamically generated by the IPv4 parameters of WAN port after you click Connect."
                }, {
                    type: "name",
                    title: "Use the following DNS Server",
                    content: "Select the checkbox to enable this option. And then enter the primary DNS/secondary DNS as provided by your ISP."
                }, {
                    type: "name",
                    title: "Connect",
                    content: "Click this button to get Internet connection."
                }, {
                    type: "name",
                    title: "Disconnect",
                    content: "Click this button to disconnect from the Internet."
                }, {
                    type: "title",
                    title: "Internet Connection Type: 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Select this type if your ISP uses 6RD deployment, and provides you with an IPv4 address and IPv6 address prefix."
                }, {
                    type: "name",
                    title: "Configuration Type",
                    content: "Select Auto or Manual for configuring the 6RD channel parameters according to your ISP. If the default parameters below coincide with those provided by your ISP, you can select Auto; otherwise, select Manual and enter the parameters as provided by your ISP."
                }, {
                    type: "name",
                    title: "IPv4 Mask Length/6RD Prefix/6RD Prefix Length/Border Reply IPv4 Address",
                    content: "Check if the preset parameters coincide with those provided by your ISP, and keep it default or manually enter them as provided by your ISP."
                }, {
                    type: "title",
                    title: "Internet Connection Type: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Select this type if your ISP uses DS-Lite deployment, and provides you with an AFTR domain name or IPv6 address, for setting up an IPv4-in-IPv6 tunnel in the IPv6 network to communicate IPv4 traffics or IPv6 traffics in their own respective network."
                }, {
                    type: "name",
                    title: "AFTR Name",
                    content: "AFTR is short for Address Family Transition Router. In this field, enter the AFTR domain name or IPv6 address as provided by your ISP."
                }, {
                    type: "name",
                    title: "Secondary Connection",
                    content: "Select the secondary connection type as provided by your ISP.",
                    children: [
                        {
                            type: "name",
                            title: "Dynamic IP",
                            content: "Select if your ISP provides you with Dynamic IP as the secondary connection type and the parameters IPv6 Address/Primary DNS/Secondary DNS will be automatically assigned by DHCPv6 server from the ISP."
                            /*children: [
						{
							type: "name",
							title: "IPv6 Address/Primary DNS/Secondary DNS",
							content: "These parameters are automatically assigned by the DHCPv6 server from your ISP."
						},{
							type: "name",
							title: "Renew",
							content: "Click this button to get new IPv6 parameters from the DHCPv6 server of the ISP."
						},{
							type: "name",
							title: "Release",
							content: "Click this button to release all IPv6 addresses assigned by DHCPv6 server from the ISP."
						},{
							type: "name",
							title: "Get IPv6 Address  ",
							content: "Click this button to release all IPv6 addresses assigned by DHCPv6 server from the ISP."
						},{
							type: "name",
							title: "DNS Address",
							content: "Select to “Get dynamically from ISP” or “Use the following DNS address”. If “Use the following DNS Address” is selected, please manually enter the DNS address provided by your ISP."
						},{
							type: "name",
							title: "Primary DNS/Secondary DNS",
							content: "Enter these parameters manually or dynamically obtain them from the ISP."
						}
					]*/
                        }, {
                            type: "name",
                            title: "Static IP",
                            content: "Select this type if your ISP uses Static IPv6 address assignment."
                            /*children: [{
						type: "name",
						title: "IPv6 Address/Default Gateway/Primary DNS/Secondary DNS",
						content: "Enter these parameters as provided by the ISP."
					},{
						type: "name",
						title: "MTU Size",
						content: "The default and typical MTU (Maximum Transmission Unit) size for most Ethernet networks is 1500 Bytes. It is not recommended to change the default MTU size unless required by the ISP."
					}]*/
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Select if your ISP provides you with PPPoE as the secondary connection type and enter username/password as provided by your ISP. The IPv6 address will be automatically assigned after you click Connect."
                            /*children: [{
						type: "name",
						title: "Username/Password",
						content: "Enter these parameters as provided by your ISP."
					},{
						type: "name",
						title: "IPv6 Address",
						content: "It will be automatically assigned by DHCPv6 server from the ISP, after you enter the username and password and click Connect."
					},{
						type: "name",
						title: "DNS Address",
						content: "Select to “Get dynamically from ISP” or “Use the following DNS address”. If “Use the following DNS Address” is selected, please manually enter the DNS address provided by your ISP."
					},{
						type: "name",
						title: "Get IPv6 Address",
						content: "Select “Non-temporary” or “Prefix delegation” or “Specified by ISP” according to your ISP. If selecting “Specified by ISP”, you need to manually enter the IPv6 address as provided by your ISP. If you select “Non-temporary” or “Prefix delegation”, the IPv6 address will be automatically assigned by the DHCPv6 server from the ISP."
					},{
						type: "name",
						title: "Connect",
						content: "Click this button to get Internet connection."
					},{
						type: "name",
						title: "Disconnect",
						content: "Click this button to disconnect from the Internet."
					}]*/
                        }
                    ]
                }, {
                    type: "title",
                    title: "Internet Connection Type: Pass Through (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Select this type if your ISP uses Pass Through (Bridge) network deployment. For this type, no parameters are provided and no configurations are needed."
                }
            ]
        },

        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Except for Pass Through (Bridge), the other 6 types of Internet connection require configurations for the IPv4 LAN parameters at the same time."
                }, {
                    type: "name",
                    title: "Assigned Type",
                    content: "Select the appropriate one according to your ISP.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "To automatically assign IP addresses to the clients in the LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Address Prefix",
                                    content: "Enter the address prefix as provided by your ISP."
                                }, {
                                    type: "name",
                                    title: "Release Time",
                                    content: "It means the time when the IP address assigned remains valid. Keep the default 86400 seconds or change it if required by your ISP."
                                }, {
                                    type: "name",
                                    title: "Address",
                                    content: "It is the IP address assigned automatically by DHCPv6 server from the ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "SLAAC+Stateless DHCP",
                            connector: " ",
                            children: [
                                {
                                    type: "name",
                                    title: "Address Prefix",
                                    content: "Enter the address prefix as provided by your ISP."
                                }, {
                                    type: "name",
                                    title: "Address",
                                    content: "It is the IP address assigned automatically by DHCPv6 server from the ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "SLAAC+RDNSS",
                            connector: " ",
                            children: [
                                {
                                    type: "name",
                                    title: "Address Prefix",
                                    content: "Enter the address prefix as provided by your ISP."
                                }, {
                                    type: "name",
                                    title: "Address",
                                    content: "It is the IP address assigned automatically by DHCPv6 server from the ISP."
                                }
                            ]
                        }
                    ]
                }
            ]
        },

        IPV6_MAC_CLONE: {
            TITLE: "MAC Clone",
            CONTENT: [
                {
                    type: "name",
                    title: "Use Default MAC Address",
                    content: "Do NOT change the default MAC address of the router, in case the ISP does not bind the assigned IP address to the MAC address."
                }, {
                    type: "name",
                    title: "Use Current Computer MAC Address",
                    content: "Select to copy the current MAC address of the computer that is connected to the router, in case the ISP binds the assigned IP address to the computer's MAC address."
                }, {
                    type: "name",
                    title: "Use Custom MAC Address",
                    content: "Enter the MAC address manually, in case the ISP binds the assigned IP address to the specific MAC address."
                }
            ]
        },

        TIME_SETTING: {
            TITLE: "Time Settings",
            CONTENT: [
                {
                    type: "step",
                    title: "To automatically synchronize the time",
                    content: ["1. Select your local <b>Time Zone</b> from the drop-down menu.", "2. In the <b>NTP Server I</b> field, enter the IP address of your desired NTP Server. (Optional)", "3. In the <b>NTP Server II</b> field, enter the IP address of the second NTP Server. (Optional)", "4. Click <b>Get GMT</b>."]
                }, {
                    type: "step",
                    title: "To manually set the date and time",
                    content: ["1. In the <b>Time Settings</b> field, select your local <b>Time Zone.</b>", "2. Enter the current <b>Date</b>.", "3. Select the current <b>Time</b> (In 24-hour clock format, e.g. 16:00:00 is 04:00PM).", "4. Click <b>Save</b>."]
                }
            ]
        },

        TIME_SETTING_DAYLIGHT: {
            TITLE: "Daylight-Saving Time",
            CONTENT: [
                {
                    type: "step",
                    title: "To set up Daylight Saving time",
                    content: ["1. Select <b>Enable Daylight Saving</b>.", "2. Select the correct <b>Start</b> date and time when daylight saving time starts at your local time zone.", "3. Select the correct <b>End</b> date and time when daylight saving time ends at your local time zone.", "4. Click <b>Save</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnostics",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The router provides Ping and Traceroute tools to help you troubleshoot network connectivity problems. The Ping tool sends packets to a target IP Address or Domain Name and logs the results, such as the number of packets sent/received, and the round-trip time. The Traceroute tool sends packets to a target IP Address or Domain Name and displays the number of hops and time to reach the destination."
                }, {
                    type: "paragraph",
                    content: "You can ping and traceroute a local device by the IP address or a domain name, such as google.com, yahoo.com, etc."
                }, {
                    type: "step",
                    title: "To diagnose using Ping",
                    content: ["1. Enter the target IP Address or Domain Name.", "2. Click the Arrow Icon to open the Advanced menu and specify the Ping Count, and Ping Packet Size. (Optional)", "3. Click Start."]
                }, {
                    type: "step",
                    title: "To diagnose using Traceroute",
                    content: ["1. Enter the target IP Address or Domain Name.", "2. Click the Arrow Icon to open the Advanced menu and specify the number of hops (to be reached) in the Traceroute Max TTL (Time to Live) field. The default is 20. (Optional) ", "3. Click Start."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Firmware Upgrade",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Before upgrading the firmware of the powerline extender, you will need to download the latest firmware update from the <a class=\"link\" href=\"http://www.tp-link.com/en/support/\" target=\"_blank\">TP-LINK Support</a> website to your computer."
                }, {
                    type: "step",
                    title: "IMPORTANT: To prevent upgrade failure, please note the following:",
                    content: ["Make sure the latest firmware file is matched with the hardware version (as shown under the Firmware Upgrade page). ", "Make sure that you have a stable connection between the powerline extender and your computer. It is NOT recommended to upgrade the firmware wirelessly.", "Backup your powerline extender configuration.", "Do NOT turn off the powerline extender during the firmware upgrade."]
                }, {
                    type: "step",
                    title: "To upgrade the powerline extender's firmware",
                    content: ["1. Click <b>Browse</b>.", "2. Locate and select the downloaded firmware file.", "3. Click <b>Upgrade</b>."]
                }, {
                    type: "paragraph",
                    content: "The upgrade process takes a few minutes to complete. Please do NOT power off the powerline extender during the upgrade process."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "To upgrade the firmware online",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Click Upgrade and click Yes when prompted, then the extender will automatically download the latest firmware file and upgrade. You can also click Check for upgrade to check the latest version."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "To upgrade the firmware manually",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Click Support at the bottom of the page and download the latest firmware to the computer. Please make sure that the firmware file you are going to download matches with the extender's hardware version as shown on the page.", "2. Click Browse and select the downloaded firmware file.", "3. Click Upgrade."]
                }, {
                    type: "paragraph",
                    content: ["The firmware upgrade takes a few minutes to complete. The extender will automatically reboot when the firmware upgrade is finished."]
                }
            ]
        },

        BACKUP: {
            TITLE: "Backup",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "It is highly recommended to back up your current configurations, in case a recovery is needed to restore the system to a previous state or from the factory defaults."
                }, {
                    type: "paragraph",
                    content: "Click <b>Backup</b> to save your current configurations to your computer. Make sure to save the backup file to a safe location that you can retrieve and restore the extender later, if needed."
                }
            ]
        },

        RESTORE: {
            TITLE: "Restore",
            CONTENT: [
                {
                    type: "step",
                    title: "To restore from a backup",
                    content: ["1. Click <b>Browse</b>.", "2. Locate and select the backup file.", "3. Click <b>Restore</b>."]
                }
            ]
        },

        FACTORY: {
            TITLE: "Factory Default Restore",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Click <b>Factory Restore</b> to reset your powerline extender to its factory default settings."
                }, {
                    type: "note",
                    title: "Note",
                    content: ["1. Factory Restore will erase all settings that you have configured for the powerline extender. To re-login to the extender's management page, use the default <b>admin</b> for both username and password.", "2. Please do NOT power off the extender during the backup or restore process."]
                }
            ]
        },

        ADMIN_ACCOUNT: {
            TITLE: "Account Management",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "This page allows you to change your login username and/or password."
                }, {
                    type: "name",
                    title: "Old Username",
                    content: "Type in your current username."
                }, {
                    type: "name",
                    title: "Old Password",
                    content: "Type in your current password."
                }, {
                    type: "name",
                    title: "New Username",
                    content: "Type in your new username."
                }, {
                    type: "name",
                    title: "New Password",
                    content: "Type in your new password."
                }, {
                    type: "name",
                    title: "Confirm New Password",
                    content: "Type in your new password again."
                }, {
                    type: "note",
                    title: "Note",
                    content: "If you change the current username and password used to log in to the powerline extender, make sure that the new login information is written down in a secure location. A strong password should be at least 8 or more characters in length, combining uppercase and lowercase letters, numbers and punctuations."
                }, {
                    type: "paragraph",
                    content: "Click <b>Save</b> to save all your settings."
                }
            ]
        },

        ADMIN_RECOVERY: {
            TITLE: "Password Recovery",
            CONTENT: [
                {
                    type: "name",
                    title: "Enable Password Recovery",
                    content: "It is highly recommended that you enable the Password Recovery feature, which will send your lost or forgotten username and password via email."
                }, {
                    type: "name",
                    title: "From",
                    content: "Enter the valid email address to be used for outgoing email."
                }, {
                    type: "name",
                    title: "To",
                    content: "Enter the valid email address to be used for incoming email."
                }, {
                    type: "name",
                    title: "SMTP Server",
                    content: "Enter the SMTP server address that the router uses to send the account information via email."
                }, {
                    type: "name",
                    title: "Enable Authentication",
                    content: " Select Enable Authentication if the outgoing email server requires authentication for sending email, and fill out the Username and Password into the corresponding fields. These fields are case-sensitive."
                }
            ]
        },

        ADMIN_LOCAL: {
            TITLE: "Local Management",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "This section allows you to limit the number of client devices on your LAN from accessing the router using the MAC address-based authentication."
                }, {
                    type: "name",
                    title: "Access for All LAN Connected Devices",
                    content: "Toggle On to enable local management for all LAN connected devices or Off to enable the management for a specific device."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the limited access device."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Displays the description of the limited access device."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the current status of the limited access device (enabled or disabled)."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify and Delete the corresponding device from the list."
                }, {
                    type: "step",
                    title: "To add a client device to the list",
                    content: ["1. Click Add.", "2. Click View Existing Devices to choose an existing device or enter the MAC address of a device into the MAC Address field.", "3. Enter a Description for the device. (Optional)", "4. Select Enable.", "5. Click OK."]
                }, {
                    type: "step",
                    title: "To modify or delete a device in the list",
                    content: "Click the Modify icon or the Delete icon that corresponds to the device that you wish to modify or delete."
                }, {
                    type: "step",
                    title: "To delete multiple devices",
                    content: "Select all the devices that you wish to delete, click Delete."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Remote Management",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The Remote Management feature allows you to access and configure the router remotely from the Internet."
                }, {
                    type: "name",
                    title: "Disable Remote Management",
                    content: "Select this option to disable the remote management."
                }, {
                    type: "name",
                    title: "Enable Remote Management for All Devices",
                    content: "Select this option to enable the remote management for all IP addresses. If selected, enter the Web Management Port field."
                }, {
                    type: "name",
                    title: "Enable Remote Management for Specified Devices",
                    content: "Select this option to enable the remote management for a specific IP address. If selected, enter the Web Management Port and Remote Management IP Address fields."
                }, {
                    type: "name",
                    title: "Web Management Port",
                    content: "Enter the port number, between 1024 and 65535, which is used to access the router’s web management interface with greater security. Normally, the web browsers use the standard HTTP service port 80. The default and common service port is 8080, which is an alternate service port of the HTTP."
                }, {
                    type: "name",
                    title: "Remote Management IP Address",
                    content: "Enter a valid IP address or IP range to be allowed to access the router. If 255.255.255.255 is entered, everyone is allowed to access."
                }
            ]
        },

        SYSTEM_LOG: {
            TITLE: "System Log",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The System Log page displays a list of the most recent activities (events) of the extender. You can define what types of logs and/or the level of logs you want to view."
                }, {
                    type: "name",
                    title: "Type",
                    content: "Select the type of system log to display."
                }, {
                    type: "name",
                    title: "Level",
                    content: "Select the level of system log to display."
                }, {
                    type: "name",
                    title: "Refresh",
                    content: "Click this icon to update the system log."
                }, {
                    type: "name",
                    title: "Delete All",
                    content: "Click this icon to delete all system logs."
                }, {
                    type: "name",
                    title: "Save log",
                    content: "Click this button to download the system log file to your local computer."
                }
            ]
        },

        TRAFFIC_STATISTIC: {
            TITLE: "Traffic Statistics",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The Traffic Statistics page displays the network traffic of the LAN, WAN, and WLAN packet send and receive."
                }, {
                    type: "note",
                    title: "Note",
                    content: "If NAT Boost is enabled, Traffic Statistics should be disabled."
                }, {
                    type: "name",
                    title: "Traffic Statistics",
                    content: "By default, the Traffic Statistics is Off. To display the statistic information, click On."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Traffic Statistics List",
            CONTENT: [
                {
                    type: "name",
                    title: "IP Address/MAC Address",
                    content: "Displays the IP address and MAC address of the associated client device."
                }, {
                    type: "name",
                    title: "Total Packets",
                    content: "Displays the total number of packets transmitted and received by the client device since the beginning of the session or the last counter reset."
                }, {
                    type: "name",
                    title: "Total Bytes",
                    content: "Displays the total number of bytes transmitted and received by the client device since the beginning of the session or the last counter reset."
                }, {
                    type: "name",
                    title: "Current Packets",
                    content: "Displays the current number of packets transmitted and received at a specific time interval."
                }, {
                    type: "name",
                    title: "Current Bytes",
                    content: "Displays the current number of bytes transmitted and received at a specific time interval."
                }, {
                    type: "name",
                    title: "Current ICMP Tx",
                    content: "Displays the current transmission rate and the maximum transmission rate of ICMP packets transmitted through the WAN port per second."
                }, {
                    type: "name",
                    title: "Current UDP Tx",
                    content: "Displays the current transmission rate and the maximum transmission rate of UDP packets transmitted through the WAN port per second."
                }, {
                    type: "name",
                    title: "Current SYN Tx",
                    content: "Displays the current transmission rate and the maximum transmission rate of TCP SYN packets transmitted through the WAN port per second."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Reset (to zero) and Delete the corresponding statistic from the list."
                }, {
                    type: "name",
                    title: "Refresh",
                    content: "Click to update the statistic information on the page."
                }, {
                    type: "name",
                    title: "Reset All",
                    content: "Click to reset all statistic values in the list to zero."
                }, {
                    type: "name",
                    title: "Delete All",
                    content: "Click to delete all statistic information in the list."
                }
            ]
        },

        SYSTEM_PARA_WIRELESS: {
            TITLE: "Wireless 2.4GHz/5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Beacon Interval",
                    content: "Enter a value between 40 and 1000 in milliseconds to determine the duration between beacon packets that are broadcasted by the router to synchronize the wireless network. The default is 100 milliseconds."
                }, {
                    type: "name",
                    title: "RTS Threshold",
                    content: "Enter a value between 1 and 2346 to determine the packet size of data transmission through the router. By default, the RTS (Request to Send) Threshold size is 2346. If the packet size is greater than the preset threshold, the router sends Request of Send frames to a particular receiving station and negotiates the sending of a data frame, or else the packet will be sent immediately."
                }, {
                    type: "name",
                    title: "DTIM Interval",
                    content: "This value determines the interval of the Delivery Traffic Indication Message (DTIM). Enter a value between 1 and 15 in milliseconds. The default value is 1, indicates the DTIM Interval is the same as Beacon Interval."
                }, {
                    type: "name",
                    title: "Group Key Update Period",
                    content: "Enter the number of seconds (minimum 30) to control the time interval for the encryption key automatic renewal. The default is 0, indicating no key renewal."
                }, {
                    type: "name",
                    title: "WMM Feature",
                    content: "The WMM function guarantees the packets with high-priority messages being transmitted preferentially. It is enabled by default and highly recommended."
                }, {
                    type: "name",
                    title: "Short GI Feature",
                    content: "This function is enabled by default and recommended to increase the data capacity by reducing the Guard Interval (GI) time."
                }, {
                    type: "name",
                    title: "AP Isolation Feature",
                    content: "By default, this function is disabled. If you want to confine and restrict all wireless devices connected to your network from interacting with each other, but still able to access the Internet, select the Enable AP Isolation checkbox."
                }, {
                    type: "name",
                    title: "WDS Bridging",
                    content: "Enable the WDS (Wireless Distribution System) Bridging feature to allow the router to bridge with another access point (AP) in a wireless local area network (WLAN). If this feature is enabled, configure the following:",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Enter the SSID of the WAP (Wireless Access Point) that the router will connect to as a client or use the Survey feature to find all available networks in the current channel."
                        }, {
                            type: "name",
                            title: "Survey",
                            content: "Click this button to scan and display the SSID, BSSID, signal strength, channel, and security information of all available wireless networks within range. Once you select a network, the SSID, MAC Address, and Security will automatically populate."
                        }, {
                            type: "name",
                            title: "MAC Address (to be bridged)",
                            content: "Enter the MAC address (BSSID) in 12 hexadecimal characters (0-9, a-f, A-F) format separated by hyphens of the wireless access point that the router will connect to as a client. If you choose the desired AP through the Survey feature, the MAC Address  field is automatically populated."
                        }, {
                            type: "name",
                            title: "Security",
                            content: "Select the correct security type of the selected access point, No, WPA-PSK/WPA2-PSK or WEP. If you choose the desired AP through the Survey feature, the Security field is automatically populated.",
                            children: [
                                {
                                    type: "name",
                                    title: "Password",
                                    content: "This option is available when the security type is WPA-PSK/WPA2-PSK or WEP. Enter the security password of the selected access point."
                                }, {
                                    type: "name",
                                    title: "Auth. Type",
                                    content: "This option is only available when the security type is WEP (Wired Equivalent Privacy). Select the appropriate authentication type (Auto, Open System or shared Key) used of the selected access point."
                                }, {
                                    type: "name",
                                    title: "WEP Key Format",
                                    content: "This option is only available when the security type is WEP. Select the key format (ASCII or Hexadecimal) used of the selected AP."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Click Save to save your settings."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Select the Enable WPS checkbox and click Save to enable the WPS (Wi-Fi Protected Setup) function that allows you to easily setup and connect the WPS-enabled devices by pushing a button."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Select the Enable NAT checkbox and click Save to enable the NAT (Network Address Translation) function."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Select the Enable NAT Boost checkbox and click Save to ensure that your router has the best throughput."
                }, {
                    type: "note",
                    title: "Note",
                    content: "NAT Boost will be disabled when either QoS or Traffic Statistics is enabled."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "DoS Protection Level Settings",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The DoS Protection Level protects the router from TCP-SYN-Flood, UDP-Flood, and ICMP-Flood attacks."
                }, {
                    type: "name",
                    title: "ICMP-FLOOD Packets Level",
                    content: "Enter a value between 5 and 7200 ICMP packets to trigger the ICMP-FLOOD protection immediately when the number of packets exceeds the preset threshold value."
                }, {
                    type: "name",
                    title: "UDP-FLOOD Packets Level",
                    content: "Enter a value between 5 and 7200 UDP packets to trigger the UDP-FLOOD protection immediately when the number of packets exceeds the preset threshold value."
                }, {
                    type: "name",
                    title: "TCP-FLOOD Packets Level",
                    content: "Enter a value between 5 and 7200 TCP-SYN packets to trigger the TCP-SYN-FLOOD protection immediately when the number of packets exceeds the preset threshold value."
                }, {
                    type: "paragraph",
                    content: "Click Save to save your settings."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Duplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Select the duplex type from the drop-down list."
                }, {
                    type: "paragraph",
                    content: "Click Save to save your settings."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Internet Status",
                    content: "Displays the current status of the Internet connection of the router."
                }, {
                    type: "name",
                    title: "Connection Type",
                    content: "Displays the type of Internet connection."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "Displays the current Internet IP address assigned to the router."
                }, {
                    type: "name",
                    title: "Secondary Connection/IP Address",
                    content: "Displays the secondary connection type and IP address."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Router",
            CONTENT: [
                {
                    type: "title",
                    title: "Wireless 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Displays the current wireless network name of the 2.4GHz/5GHz band frequency."
                }, {
                    type: "name",
                    title: "Channel",
                    content: "Displays the channel of which the wireless 2.4GHz/5GHz network broadcasts."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "Displays the current MAC address of the wireless 2.4GHz/5GHz."
                }, {
                    type: "title",
                    title: "2.4GHz/5GHz Wireless Network"
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays whether the wireless Guest Network 2.4GHz/5GHz is on (enabled) or off (disabled)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Displays the wireless network name of Guest Network."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Wireless/Wired Clients",
            CONTENT: [
                {
                    type: "name",
                    title: "Name",
                    content: "Displays the name of the client connected to the router."
                }, {
                    type: "name",
                    title: "IP Address",
                    content: "Displays the assigned IP address of the client."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of the client."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Printer",
            CONTENT: [
                {
                    type: "name",
                    title: "Name",
                    content: "Displays the name of the printer connected to the router via USB port."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "USB DISK",
            CONTENT: [
                {
                    type: "name",
                    title: "USB Disk",
                    content: "Displays the brand of the USB disk connected to the router."
                }, {
                    type: "name",
                    title: "Total",
                    content: "Displays the total volume of the USB disk."
                }, {
                    type: "name",
                    title: "Available",
                    content: "Displays the available space of the USB disk."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Auto Detect",
                    content: "Click this button to have the router automatically detect your current Internet connection type."
                }, {
                    type: "note",
                    title: "Note",
                    content: "If you are not sure which Internet connection type you have, use the Auto Detect function or contact your ISP for assistance."
                }, {
                    type: "title",
                    title: "Internet Connection Type: Static IP"
                }, {
                    type: "name",
                    title: "IP Address/Subnet Mask/Default Gateway/Primary DNS/Secondary DNS",
                    content: "Enter the information provided by your ISP."
                }, {
                    type: "title",
                    title: "Internet Connection Type: Dynamic IP"
                }, {
                    type: "name",
                    title: "Do NOT Clone MAC Address/Clone Current Computer MAC Address",
                    content: "Select whether to clone your MAC address or not, according to your ISP."
                }, {
                    type: "title",
                    title: "Internet Connection Type: PPPoE"
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter the username and password provided by your ISP. These fields are case-sensitive."
                }, {
                    type: "title",
                    title: "Internet Connection Type: L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Enter the username and password provided by your ISP. These fields are case-sensitive."
                }, {
                    type: "name",
                    title: "Secondary Connection (Dynamic IP or Static IP)",
                    children: [
                        {
                            type: "name",
                            title: "Dynamic IP",
                            content: "Select if the IP address and Subnet Mask are assigned automatically by the ISP."
                        }, {
                            type: "name",
                            title: "Static IP",
                            content: " Select if the IP address, Subnet Mask, Gateway, and DNS addresses are provided by the ISP, and enter these information into the corresponding fields."
                        }
                    ]
                }, {
                    type: "name",
                    title: "VPN Server IP/Domain Name",
                    content: "Enter the VPN server’s IP address or domain name provided by your ISP."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "Wireless Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "Enable Wireless Radio",
                    content: "Select this checkbox to enable the 2.4GHz/5GHz wireless radio frequency."
                }, {
                    type: "name",
                    title: "Wireless Network Name (SSID)",
                    content: "You can leave the default wireless network name (SSID) as it is or enter a new name (up to 32 characters). This field is case-sensitive."
                }, {
                    type: "name",
                    title: "Hide SSID",
                    content: "Select this checkbox if you want to hide the 2.4GHz/5GHz network name (SSID) from the Wi-Fi network list."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Enter a wireless password between 8 and 63 ASCII characters, or between 8 and 64 hexadecimal characters into this field (case-sensitive)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Device Settings",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The Device Settings page displays the related information of any connected USB storage device via the USB port."
                }, {
                    type: "name",
                    title: "Scan",
                    content: "Usually, the router automatically detects any newly attached device. If not, click this button to scan for any new connected device and refresh the page with the updated information."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Displays the name of the USB volume."
                }, {
                    type: "name",
                    title: "Capacity",
                    content: "Displays the total storage capacity of the USB."
                }, {
                    type: "name",
                    title: "Free Space",
                    content: "Displays the current available free storage space."
                }, {
                    type: "name",
                    title: "Safely Remove",
                    content: "Click this button to safely unmount the USB storage device before physically disconnecting it from the router.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Please note that the Safely Remove button only appears when there is a USB storage device connected to the router. Also, keep in mind that you are unable to unmount the USB device while the current volume is busy."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Active",
                    content: "This checkbox only appears when there is a USB storage device connected to the router. Select to enable file sharing of the USB device."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Sharing Settings",
            CONTENT: [
                {
                    type: "name",
                    title: "Network/Media Server Name",
                    content: "Displays the name used to access the connected USB storage device."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Folder Sharing",
            CONTENT: [
                {
                    type: "name",
                    title: "Share All",
                    content: "Toggle On to share all files and folders or Off to only share the selected folders."
                }, {
                    type: "name",
                    title: "Enable Authentication",
                    content: "It is strongly recommended to enable authentication to require users to enter a valid username and password to access the sharing folders."
                }, {
                    type: "name",
                    title: "Folder Name",
                    content: "Displays the name of the shared folder."
                }, {
                    type: "name",
                    title: "Folder Path",
                    content: "Displays the path to the shared folder."
                }, {
                    type: "name",
                    title: "Media Sharing",
                    content: "Indicates whether the shared folder is allowed for media sharing or not."
                }, {
                    type: "name",
                    title: "Volume Name",
                    content: "Displays the name of the shared volume."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the status of the shared folder by the light bulb indicator. Green (ON) is enabled and Grey (OFF) is disabled. You can enable or disable sharing by clicking the bulb."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify and Delete the corresponding shared folder."
                }, {
                    type: "name",
                    title: "Add",
                    content: "Click this button to create a new entry."
                }, {
                    type: "name",
                    title: "Delete",
                    content: "Click this button to remove the selected entry from the table."
                }, {
                    type: "name",
                    title: "Browse",
                    content: "Click to search for a shared folder."
                }, {
                    type: "name",
                    title: "Allow Guest Network Access",
                    content: "Select to allow clients on Guest Network to access the shared folders."
                }, {
                    type: "name",
                    title: "Enable Authentication",
                    content: "Select to require users to access the shared folders with a valid username and password."
                }, {
                    type: "name",
                    title: "Enable Write Access",
                    content: "Select to allow users to make changes to the folder content."
                }, {
                    type: "name",
                    title: "Enable Media Sharing",
                    content: "Select to enable media sharing."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Print Server",
            CONTENT: [
                {
                    type: "name",
                    title: "Enable Print Server",
                    content: "Click On to enable the print server function."
                }, {
                    type: "name",
                    title: "Printer Name",
                    content: "Displays the name of your printer connected to the router."
                }, {
                    type: "step",
                    title: "To set up a Print Server that can be used across your network",
                    content: ["1.	Connect a USB printer to the USB port of the router via a USB cable.", "2.	Install the printer driver on your computer. Refer to the computer manufacturer’s manuals for instructions.", "3.	Install the TP-LINK USB Printer Controller Utility either from the Resource CD (for Windows only) or download it (for both Windows and Mac OS X) from TP-LINK’s official website."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Parental Control",
            CONTENT: [
                {
                    type: "name",
                    title: "Status",
                    content: "Toggle On to enable the Parental Control feature. By default, this feature is disabled."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Devices Under Parental Control",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Displays the list of devices under Parental Control."
                }, {
                    type: "name",
                    title: "Device Name",
                    content: "Displays the name of all connected client devices that are currently under Parental Control."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "Displays the MAC address of all connected client devices that are currently under Parental Control."
                }, {
                    type: "name",
                    title: "Internet Access Time",
                    content: "Displays the restriction access time periods."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Displays a brief description of the connected device. It is an optional setting."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Displays the current status (enabled or disabled) of the Parental Control of the corresponding device."
                }, {
                    type: "name",
                    title: "Modify",
                    content: "Displays options to Modify or Delete the corresponding device."
                }, {
                    type: "step",
                    title: "To restrict a new client device",
                    content: [
                        "1.	Click Add.",
                        "2.	Click View Existing Devices and choose a currently connected device from the Access Devices List; or enter the Device Name and MAC Address manually to add a device that is not connected.",
                        "3.	Click the Internet Access Time icon to specify a time period during which the restriction applies.",
                        "4. Enter a brief description into the Description field. (Optional)",
                        "5. Select Enable.",
                        "6. Click OK to save this entry."
                    ]
                }, {
                    type: "paragraph",
                    content: "To modify or delete a Parental Control entry, simply click the Modify icon to edit the information or the Delete icon to remove the corresponding entry."
                }, {
                    type: "paragraph",
                    content: "To delete multiple entries, select all the entries and click Delete above the table."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Guest Network",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Guest Network allows you to set up a separate network with a separate wireless network name (SSID) and password that guests can use to access your wireless network."
                }, {
                    type: "name",
                    title: "Allow guests to see each other",
                    content: "Select this checkbox to allow the wireless devices on the Guest Network to see each other."
                }, {
                    type: "name",
                    title: "Do not allow guests to manage my network.",
                    content: "Select this option to prevent guests from logging into web management interfaces."
                }, {
                    type: "name",
                    title: "Enable Guest Network",
                    content: "Select this checkbox to enable the 2.4GHz/5GHz Guest Network feature."
                }, {
                    type: "name",
                    title: "Wireless Network Name (SSID)",
                    content: "Either use the default Guest SSID or create a new name (up to 32 characters)."
                }, {
                    type: "name",
                    title: "Hide SSID",
                    content: "Select this checkbox if you want to hide the Guest SSID from the Wi-Fi network list."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create a password between 8 and 63 ASCII characters, or between 8 and 64 hexadecimal characters (0-9, a-f, A-F), to secure the Guest Network."
                }
            ]
        }

    };
})(jQuery);
